/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence;

import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import pl.pabilo8.immersiveintelligence.api.data.radio.RadioNetwork;
import pl.pabilo8.immersiveintelligence.common.CommonProxy;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.IISaveData;
import pl.pabilo8.immersiveintelligence.common.IISounds;
import pl.pabilo8.immersiveintelligence.common.commands.ii.CommandII;
import pl.pabilo8.immersiveintelligence.common.compat.IICompatModule;
import pl.pabilo8.immersiveintelligence.common.util.IISkinHandler;

@Mod(modid="immersiveintelligence", version="0.3.0", certificateFingerprint="770570c49a2652e64a9b29b9b9d9919ca68b7065", dependencies="required-after:forge@[14.23.5.2820,);required-after:immersiveengineering@[0.12,);after:immersiveengineering@[0.12,);after:immersiveposts@[0.2,);before:buildcraftlib", acceptedMinecraftVersions="[1.12.2]")
public class ImmersiveIntelligence {
    public static final String MODID = "immersiveintelligence";
    public static final String VERSION = "0.3.0";
    @SidedProxy(clientSide="pl.pabilo8.immersiveintelligence.client.ClientProxy", serverSide="pl.pabilo8.immersiveintelligence.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="immersiveintelligence")
    public static ImmersiveIntelligence INSTANCE;
    private static final String[] alternativeCerts;

    @Mod.EventHandler
    public void modIDMapping(FMLModIdMappingEvent event) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IILogger.logger = event.getModLog();
        proxy.preInit();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)proxy);
        new IISkinHandler.ThreadContributorSpecialsDownloader();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)proxy);
        proxy.init();
        IISounds.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        IICompatModule.doModulesLoadComplete();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            RadioNetwork.INSTANCE.clearDevices();
            World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
            if (!world.field_72995_K) {
                IISaveData worldData = (IISaveData)world.func_72943_a(IISaveData.class, "ImmersiveIntelligence-SaveData");
                if (worldData == null) {
                    worldData = new IISaveData("ImmersiveIntelligence-SaveData");
                    world.func_72823_a("ImmersiveIntelligence-SaveData", (WorldSavedData)worldData);
                }
                IISaveData.setInstance(world.field_73011_w.getDimension(), worldData);
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandII());
    }

    @Mod.EventHandler
    public void wrongSignature(FMLFingerprintViolationEvent event) {
        boolean loicense = false;
        for (String altCert : alternativeCerts) {
            if (!event.getFingerprints().contains(altCert)) continue;
            System.out.println("[Immersive Intelligence/Error] " + altCert + " is considered a righteously loicensed certificate. The build may not be stable, thou shall be ware of the bugs lurking from the shadows.");
            loicense = true;
            break;
        }
        if (!loicense) {
            System.out.println("[Immersive Intelligence/Error]IT IS VERY PROBABLE, THE ENTITY WHO RELEASED THIS BUILD DOES NOT POSSESS A PROPER IMMERSIVE INTELLIGENCE LOICENSE! ");
            System.out.println("[Immersive Intelligence/Error]CONTACT THE MINISTRY OF INTELLIGENCE IMMEDIATELLY! ");
            System.out.println("[Immersive Intelligence/Error]FOUND THESE ILLEGAL FINGERPRINTS: " + event.getFingerprints());
        }
    }

    static {
        alternativeCerts = new String[]{"4e1045a33d925770c5393a384c1a60f63f8f50e5", "0f6c85efeabec62835f1fb26ff0ad1ae6f1af9cb"};
    }
}

