/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;

public class PackerHandler {
    private static HashMap<Predicate<ItemStack>, Function<ItemStack, IItemHandler>> itemHandleMap = new HashMap();
    private static HashMap<Predicate<ItemStack>, Function<ItemStack, IFluidHandlerItem>> fluidHandleMap = new HashMap();

    public static void registerItem(Predicate<ItemStack> check, Function<ItemStack, IItemHandler> handler) {
        itemHandleMap.put(check, handler);
    }

    public static void registerFluid(Predicate<ItemStack> check, Function<ItemStack, IFluidHandlerItem> handler) {
        fluidHandleMap.put(check, handler);
    }

    public static Stream<Map.Entry<Predicate<ItemStack>, Function<ItemStack, IItemHandler>>> streamItems() {
        return itemHandleMap.entrySet().stream();
    }

    public static Stream<Map.Entry<Predicate<ItemStack>, Function<ItemStack, IFluidHandlerItem>>> streamFluids() {
        return fluidHandleMap.entrySet().stream();
    }

    @ParametersAreNonnullByDefault
    public static class PackerTask {
        public PackerPutMode mode;
        public PackerActionType actionType;
        public IngredientStack stack;
        public int expirationAmount = -1;
        public boolean unpack = false;

        public PackerTask(PackerPutMode mode, PackerActionType actionType, IngredientStack stack) {
            this.actionType = actionType;
            this.mode = mode;
            this.stack = stack;
        }

        public PackerTask(NBTTagCompound nbt) {
            this(PackerPutMode.valueOf(nbt.func_74779_i("mode").toUpperCase()), PackerActionType.valueOf(nbt.func_74779_i("action_type").toUpperCase()), IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("stack")));
            if (nbt.func_74764_b("expiration_amount")) {
                this.expirationAmount = nbt.func_74762_e("expiration_amount");
            }
            this.unpack = nbt.func_74767_n("unpack");
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("mode", this.mode.func_176610_l());
            nbt.func_74778_a("action_type", this.actionType.name().toLowerCase());
            nbt.func_74782_a("stack", (NBTBase)this.stack.writeToNBT(new NBTTagCompound()));
            if (this.expirationAmount != -1) {
                nbt.func_74768_a("expiration_amount", this.expirationAmount);
            }
            nbt.func_74757_a("unpack", this.unpack);
            return nbt;
        }
    }

    public static enum PackerActionType {
        ITEM,
        FLUID,
        ENERGY;


        public String getActionName(boolean unpacker) {
            switch (this) {
                default: {
                    return unpacker ? "unpack" : "pack";
                }
                case FLUID: {
                    return unpacker ? "drain" : "fill";
                }
                case ENERGY: 
            }
            return unpacker ? "discharge" : "charge";
        }

        public static PackerActionType fromName(String name) {
            switch (name.toLowerCase()) {
                default: {
                    return ITEM;
                }
                case "fluid": {
                    return FLUID;
                }
                case "energy": 
            }
            return ENERGY;
        }
    }

    public static enum PackerPutMode implements IStringSerializable
    {
        ALL_POSSIBLE,
        SLOT,
        AMOUNT,
        AT_MOST_CONTAINER,
        AT_LEAST_PACKER;


        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static PackerPutMode fromName(String name) {
            String ss = name.toUpperCase();
            return Arrays.stream(PackerPutMode.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(ALL_POSSIBLE);
        }
    }
}

