/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoCore;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;
import pl.pabilo8.immersiveintelligence.common.ammo.cores.AmmoCoreMissingNo;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;

public class AmmoRegistry {
    private static final AmmoCoreMissingNo MISSING_CORE = new AmmoCoreMissingNo();
    public static AmmoRegistry INSTANCE = new AmmoRegistry();
    public LinkedHashMap<String, IAmmoComponent> registeredComponents = new LinkedHashMap();
    public LinkedHashMap<String, IAmmoCore> registeredBulletCores = new LinkedHashMap();
    public LinkedHashMap<String, IAmmo> registeredBulletItems = new LinkedHashMap();
    public HashMap<String, IBulletModel> registeredModels = new HashMap();

    public boolean registerComponent(IAmmoComponent component) {
        String name = component.getName();
        if (!this.registeredComponents.containsKey(name)) {
            this.registeredComponents.put(name, component);
            return true;
        }
        return false;
    }

    public boolean registerBulletCore(IAmmoCore core) {
        String name = core.getName();
        if (!this.registeredBulletCores.containsKey(name)) {
            this.registeredBulletCores.put(name, core);
            return true;
        }
        return false;
    }

    public boolean registerBulletItem(IAmmo casing) {
        String name = casing.getName();
        if (!this.registeredBulletItems.containsKey(name)) {
            this.registeredBulletItems.put(name, casing);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                try {
                    IBulletModel iBulletModel = casing.getModel().newInstance();
                    iBulletModel.subscribeToList(casing.getName());
                    this.registeredModels.put(casing.getName(), iBulletModel);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IAmmoComponent getComponent(String name) {
        return this.registeredComponents.get(name);
    }

    @Nullable
    public IAmmo getBulletItem(String name) {
        return this.registeredBulletItems.get(name);
    }

    @Nonnull
    public IAmmoCore getCore(String name) {
        return this.registeredBulletCores.getOrDefault(name, MISSING_CORE);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBulletModel getModel(IAmmo bullet) {
        return this.registeredModels.get(bullet.getName());
    }

    public static enum PenMaterialTypes {
        METAL(true),
        GROUND(false),
        SOLID(true),
        FLESH(false),
        LIGHT(false);

        private final boolean ricochet;

        private PenMaterialTypes(boolean ricochet) {
            this.ricochet = ricochet;
        }

        public boolean canRicochetOff() {
            return this.ricochet;
        }

        public static PenMaterialTypes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(PenMaterialTypes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(METAL);
        }
    }

    public static enum EnumFuseTypes implements ISerializableEnum
    {
        CONTACT('\u29b0'),
        TIMED('\u29b1'),
        PROXIMITY('\u29b2');

        public final char symbol;

        private EnumFuseTypes(char symbol) {
            this.symbol = symbol;
        }

        @Nonnull
        public static EnumFuseTypes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(EnumFuseTypes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(CONTACT);
        }
    }

    public static enum EnumCoreTypes implements ISerializableEnum
    {
        SOFTPOINT(2, 0.5f, 1.0f, 1.0f, EnumComponentRole.GENERAL_PURPOSE){

            @Override
            public float getDamageMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.FLESH ? 1.65f : 1.0f;
            }
        }
        ,
        SHAPED(3, 0.5f, 1.25f, 1.0f, EnumComponentRole.GENERAL_PURPOSE){

            @Override
            public float getPenMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.METAL ? 1.5f : 0.5f;
            }

            @Override
            public float getDamageMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.METAL ? 1.85f : 1.0f;
            }
        }
        ,
        PIERCING(1, 1.35f, 0.75f, 1.0f, EnumComponentRole.PIERCING),
        PIERCING_SABOT(0, 2.0f, 0.0f, 0.85f, EnumComponentRole.PIERCING){

            @Override
            public float getPenMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.GROUND || p == PenMaterialTypes.SOLID ? 1.15f : 2.0f;
            }
        }
        ,
        CANISTER(4, 0.125f, 1.25f, 0.125f, EnumComponentRole.GENERAL_PURPOSE){

            @Override
            public float getPenMod(PenMaterialTypes p) {
                return p == PenMaterialTypes.LIGHT ? 1.0f : 0.125f;
            }
        };

        private final int componentSlots;
        private final float componentEffectivenessMod;
        private final Function<PenMaterialTypes, Float> getPenEffectiveness;
        private final Function<PenMaterialTypes, Float> getDamageMod;
        @Nullable
        private final EnumComponentRole role;

        private EnumCoreTypes(int componentSlots, float penHardnessMod, @Nullable float componentEffectivenessMod, float damageMod, EnumComponentRole role) {
            this.componentSlots = componentSlots;
            this.getPenEffectiveness = penMaterialTypes -> Float.valueOf(penHardnessMod);
            this.componentEffectivenessMod = componentEffectivenessMod;
            this.getDamageMod = penMaterialTypes -> Float.valueOf(damageMod);
            this.role = role;
        }

        public float getPenMod(PenMaterialTypes p) {
            return this.getPenEffectiveness.apply(p).floatValue();
        }

        public float getDamageMod(PenMaterialTypes p) {
            return this.getDamageMod.apply(p).floatValue();
        }

        public int getComponentSlots() {
            return this.componentSlots;
        }

        public float getComponentEffectivenessMod() {
            return this.componentEffectivenessMod;
        }

        @Nullable
        public EnumComponentRole getRole() {
            return this.role;
        }

        @Nonnull
        public static EnumCoreTypes v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(EnumCoreTypes.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(SOFTPOINT);
        }
    }

    public static enum EnumComponentRole implements ISerializableEnum
    {
        GENERAL_PURPOSE(0xAAAAAA),
        SHRAPNEL(89728005),
        PIERCING(14432569),
        EXPLOSIVE(14463845),
        INCENDIARY(7744813),
        TRACER(6525148),
        FLARE(12084188),
        CHEMICAL(8510564),
        SPECIAL(6544577);

        private final int color;

        private EnumComponentRole(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }

        @Nonnull
        public static EnumComponentRole v(String s) {
            String ss = s.toUpperCase();
            return Arrays.stream(EnumComponentRole.values()).filter(e -> e.name().equals(ss)).findFirst().orElse(GENERAL_PURPOSE);
        }
    }
}

