/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoCore;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;

public interface IAmmo
extends ItemTooltipHandler.IAdvancedTooltipItem {
    public String getName();

    public float getComponentMultiplier();

    default public int getGunpowderNeeded() {
        return 0;
    }

    public int getCoreMaterialNeeded();

    public float getInitialMass();

    public float getDefaultVelocity();

    public float getCaliber();

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Class<? extends IBulletModel> getModel();

    public float getDamage();

    public ItemStack getCasingStack(int var1);

    public AmmoRegistry.EnumCoreTypes[] getAllowedCoreTypes();

    default public float getSupressionRadius() {
        return 0.0f;
    }

    default public int getSuppressionPower() {
        return 0;
    }

    public IAmmoCore getCore(ItemStack var1);

    public AmmoRegistry.EnumCoreTypes getCoreType(ItemStack var1);

    public IAmmoComponent[] getComponents(ItemStack var1);

    public void addComponents(ItemStack var1, IAmmoComponent var2, NBTTagCompound var3);

    public NBTTagCompound[] getComponentsNBT(ItemStack var1);

    public ItemStack setComponentNBT(ItemStack var1, NBTTagCompound ... var2);

    public int getPaintColor(ItemStack var1);

    public ItemStack setPaintColour(ItemStack var1, int var2);

    default public float getMass(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0.01f;
        }
        return this.getCoreMass(this.getCore(stack), this.getComponents(stack));
    }

    default public float getCoreMass(IAmmoCore core, IAmmoComponent[] components) {
        return (float)((double)this.getInitialMass() * ((double)(1.0f + core.getDensity()) + Arrays.stream(components).mapToDouble(IAmmoComponent::getDensity).sum()));
    }

    default public boolean shouldLoadChunks() {
        return false;
    }

    public void registerSprites(TextureMap var1);

    default public ItemStack getBulletWithParams(IAmmoCore core, AmmoRegistry.EnumCoreTypes coreType, IAmmoComponent ... components) {
        String[] compNames = (String[])Arrays.stream(components).map(IAmmoComponent::getName).toArray(String[]::new);
        return this.getBulletWithParams(core.getName(), coreType.func_176610_l(), compNames);
    }

    default public ItemStack getBulletCore(IAmmoCore core, AmmoRegistry.EnumCoreTypes coreType) {
        return this.getBulletCore(core.getName(), coreType.func_176610_l());
    }

    public ItemStack getBulletWithParams(String var1, String var2, String ... var3);

    public ItemStack getBulletCore(String var1, String var2);

    public boolean isBulletCore(ItemStack var1);

    public AmmoRegistry.EnumFuseTypes[] getAllowedFuseTypes();

    public void setFuseType(ItemStack var1, AmmoRegistry.EnumFuseTypes var2);

    public AmmoRegistry.EnumFuseTypes getFuseType(ItemStack var1);

    default public boolean hasFreeComponentSlots(ItemStack stack) {
        return this.getComponents(stack).length < this.getCoreType(stack).getComponentSlots();
    }

    default public int getFuseParameter(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"fuse_param");
    }

    default public void setFuseParameter(ItemStack stack, int p) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"fuse_param", (int)p);
    }

    default public boolean isProjectile() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    default public void addAdvancedInformation(ItemStack stack, int offsetX, List<Integer> offsetsY) {
        IAmmoComponent[] components = this.getComponents(stack);
        if (components.length > 0 && ItemTooltipHandler.canExpandTooltip(42)) {
            ItemTooltipHandler.drawItemList(offsetX, (int)offsetsY.get(0), (ItemStack[])Arrays.stream(components).map(c -> c.getMaterial().getExampleStack()).toArray(ItemStack[]::new));
        }
    }
}

