/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.api.crafting.DustStack;

public class DustUtils {
    private static final HashMultimap<String, IngredientStack> dustIngredients = HashMultimap.create();
    private static final HashMap<String, Integer> dustColors = new HashMap();

    public static void registerDust(IngredientStack stack, String name) {
        DustUtils.registerDust(stack, name, 0);
    }

    public static void registerDust(IngredientStack stack, String name, int color) {
        dustIngredients.put((Object)name, (Object)stack);
        if (!dustColors.containsKey(name)) {
            dustColors.put(name, color);
        }
    }

    public static boolean isDustStack(ItemStack stack) {
        return dustIngredients.entries().stream().anyMatch(s -> ((IngredientStack)s.getValue()).matchesItemStackIgnoringSize(stack));
    }

    public static DustStack fromItemStack(ItemStack stack) {
        Optional<Map.Entry> first = dustIngredients.entries().stream().filter(s -> ((IngredientStack)s.getValue()).matchesItemStackIgnoringSize(stack)).findFirst();
        return first.map(stringIngredientStackEntry -> new DustStack((String)stringIngredientStackEntry.getKey(), stack.func_190916_E() * ((IngredientStack)stringIngredientStackEntry.getValue()).inputSize)).orElse(DustStack.getEmptyStack());
    }

    public static DustStack fromIngredient(IngredientStack stack) {
        Optional<Map.Entry> first = dustIngredients.entries().stream().filter(s -> ApiUtils.stackMatchesObject((ItemStack)stack.getExampleStack(), s.getValue())).findFirst();
        return first.map(stringIngredientStackEntry -> new DustStack((String)stringIngredientStackEntry.getKey(), stack.inputSize * ((IngredientStack)stringIngredientStackEntry.getValue()).inputSize)).orElse(DustStack.getEmptyStack());
    }

    public static int getColor(DustStack stack) {
        return dustColors.get(stack.name);
    }

    public static ItemStack[] fromDustStack(DustStack dust) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Map.Entry[] matching = (Map.Entry[])dustIngredients.entries().stream().filter(e -> ((String)e.getKey()).equals(dust.name)).sorted(Comparator.comparingInt(o -> ((IngredientStack)o.getValue()).inputSize)).toArray(Map.Entry[]::new);
        int i = dust.amount;
        for (Map.Entry entry : matching) {
            int l = (int)Math.floor((float)i / (float)((IngredientStack)entry.getValue()).inputSize);
            ItemStack copy = ((IngredientStack)entry.getValue()).getExampleStack().func_77946_l();
            copy.func_190920_e(l);
            list.add(copy);
            if ((i -= l * ((IngredientStack)entry.getValue()).inputSize) == 0) break;
        }
        return list.toArray(new ItemStack[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getDustName(DustStack dustStorage) {
        return dustStorage.isEmpty() ? "" : I18n.func_135052_a((String)("dust." + dustStorage.name), (Object[])new Object[0]);
    }
}

