/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.production.TileEntityMultiblockProductionBase;

public class ElectrolyzerRecipe
extends MultiblockRecipe
implements TileEntityMultiblockProductionBase.IIIMultiblockRecipe {
    public final FluidStack fluidInput;
    public final FluidStack[] fluidOutputs = new FluidStack[2];
    public static ArrayList<ElectrolyzerRecipe> recipeList = new ArrayList();
    int totalProcessTime;
    int totalProcessEnergy;
    public int energyPerTick;

    public ElectrolyzerRecipe(FluidStack fluidInput, FluidStack fluidOutput1, @Nullable FluidStack fluidOutput2, int energy, int time) {
        this.fluidOutputs[0] = fluidOutput1;
        this.fluidOutputs[1] = fluidOutput2;
        this.fluidInput = fluidInput;
        this.totalProcessEnergy = energy;
        this.totalProcessTime = time;
        this.fluidInputList = Collections.singletonList(this.fluidInput);
        this.fluidOutputList = Arrays.asList(this.fluidOutputs);
        this.energyPerTick = (int)Math.floor((float)energy / (float)time);
    }

    public static ElectrolyzerRecipe addRecipe(FluidStack fluidInput, FluidStack fluidOutput1, FluidStack fluidOutput2, int energy, int time) {
        int gcd = IIUtils.gcd(fluidInput.amount, fluidOutput1.amount, fluidOutput2.amount, energy, time);
        fluidInput.amount /= gcd;
        fluidOutput1.amount /= gcd;
        fluidOutput2.amount /= gcd;
        ElectrolyzerRecipe r = new ElectrolyzerRecipe(fluidInput, fluidOutput1, fluidOutput2, energy /= gcd, time /= gcd);
        recipeList.add(r);
        return r;
    }

    public static List<ElectrolyzerRecipe> removeRecipesForInput(FluidStack fluidInput) {
        List<ElectrolyzerRecipe> recipes = recipeList.stream().filter(r -> r.fluidInput.isFluidEqual(fluidInput)).collect(Collectors.toList());
        recipeList.removeAll(recipes);
        return recipes;
    }

    public static ElectrolyzerRecipe findRecipe(FluidStack fluidInput) {
        for (ElectrolyzerRecipe recipe : recipeList) {
            if (recipe.fluidInput.getFluid() != fluidInput.getFluid() || fluidInput.amount < recipe.fluidInput.amount) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("fluid_input", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static ElectrolyzerRecipe loadFromNBT(NBTTagCompound nbt) {
        FluidStack fluid_input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid_input"));
        return ElectrolyzerRecipe.findRecipe(fluid_input);
    }

    @Override
    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    @Override
    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }
}

