/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.crafting.DustStack;

public class FillerRecipe
extends MultiblockRecipe {
    public final IngredientStack itemInput;
    public final ItemStack itemOutput;
    public static ArrayList<FillerRecipe> recipeList = new ArrayList();
    public DustStack dust;
    int totalProcessTime;
    int totalProcessEnergy;
    IAmmo bullet = null;

    public FillerRecipe(ItemStack itemOutput, Object itemInput, DustStack dust, int time, int energy) {
        this.itemOutput = itemOutput;
        this.itemInput = ApiUtils.createIngredientStack((Object)itemInput);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.itemInput});
        this.outputList = ListUtils.fromItem((ItemStack)this.itemOutput);
        if (itemOutput.func_77973_b() instanceof IAmmo) {
            this.bullet = (IAmmo)itemOutput.func_77973_b();
        }
        this.dust = dust;
        this.totalProcessTime = time;
        this.totalProcessEnergy = energy;
    }

    public static FillerRecipe addRecipe(ItemStack itemOutput, IngredientStack itemInput, DustStack dust, int time, int energy) {
        FillerRecipe r = new FillerRecipe(itemOutput, itemInput, dust, time, energy);
        recipeList.add(r);
        return r;
    }

    public static <T extends Item> FillerRecipe addRecipe(T bulletItem, int time, int energy) {
        ItemStack casingStack = ((IAmmo)bulletItem).getCasingStack(1);
        ItemNBTHelper.setBoolean((ItemStack)casingStack, (String)"ii_FilledCasing", (boolean)true);
        FillerRecipe recipe = FillerRecipe.addRecipe(casingStack, new IngredientStack(((IAmmo)bulletItem).getCasingStack(1)).setUseNBT(true), new DustStack("gunpowder", ((IAmmo)bulletItem).getGunpowderNeeded()), time, energy);
        recipe.bullet = (IAmmo)bulletItem;
        return recipe;
    }

    public static List<FillerRecipe> removeRecipesForOutput(ItemStack stack) {
        ArrayList<FillerRecipe> list = new ArrayList<FillerRecipe>();
        Iterator<FillerRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            FillerRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.itemOutput, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static FillerRecipe findRecipe(IngredientStack item_input, DustStack stack) {
        for (FillerRecipe recipe : recipeList) {
            if (!recipe.itemInput.matches((Object)item_input) || !recipe.dust.canMergeWith(stack) || recipe.dust.amount > stack.amount) continue;
            return recipe;
        }
        return null;
    }

    public static FillerRecipe findRecipe(ItemStack item_input, DustStack stack) {
        for (FillerRecipe recipe : recipeList) {
            if (!recipe.itemInput.matches((Object)item_input) || !recipe.dust.canMergeWith(stack) || recipe.dust.amount > stack.amount) continue;
            return recipe;
        }
        return null;
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public static FillerRecipe loadFromNBT(NBTTagCompound nbt) {
        return FillerRecipe.findRecipe(IngredientStack.readFromNBT((NBTTagCompound)nbt.func_74775_l("item_input")), new DustStack(nbt.func_74775_l("dust")));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("item_input", (NBTBase)this.itemInput.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("dust", (NBTBase)this.dust.serializeNBT());
        return nbt;
    }

    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public DustStack getDust() {
        return this.dust;
    }

    @Nullable
    public IAmmo getBullet() {
        return this.bullet;
    }
}

