/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeBoolean;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;

public class DataHandlingUtils {
    public static boolean asBoolean(char variable, DataPacket packet) {
        return packet.getVarInType(DataTypeBoolean.class, (IDataType)packet.getPacketVariable((Character)Character.valueOf((char)variable))).value;
    }

    public static int asInt(char variable, DataPacket packet) {
        return packet.getVarInType(IDataTypeNumeric.class, packet.getPacketVariable(Character.valueOf(variable))).intValue();
    }

    public static float asFloat(char variable, DataPacket packet) {
        return packet.getVarInType(IDataTypeNumeric.class, packet.getPacketVariable(Character.valueOf(variable))).floatValue();
    }

    public static String asString(char variable, DataPacket packet) {
        return packet.getPacketVariable(Character.valueOf(variable)).valueToString();
    }

    public static boolean expectingNumericParam(char variable, DataPacket packet, Consumer<Float> ifPresent) {
        boolean present = packet.getPacketVariable(Character.valueOf(variable)) instanceof IDataTypeNumeric;
        if (present) {
            ifPresent.accept(Float.valueOf(((IDataTypeNumeric)packet.getPacketVariable(Character.valueOf(variable))).floatValue()));
        }
        return present;
    }

    public static boolean expectingBooleanParam(char variable, DataPacket packet, Consumer<Boolean> ifPresent) {
        boolean present = packet.getPacketVariable(Character.valueOf(variable)) instanceof DataTypeBoolean;
        if (present) {
            ifPresent.accept(((DataTypeBoolean)packet.getPacketVariable((Character)Character.valueOf((char)variable))).value);
        }
        return present;
    }

    public static boolean expectingStringParam(char variable, DataPacket packet, Consumer<String> ifPresent) {
        boolean present = packet.getPacketVariable(Character.valueOf(variable)) instanceof DataTypeString;
        if (present) {
            ifPresent.accept(((DataTypeString)packet.getPacketVariable((Character)Character.valueOf((char)variable))).value);
        }
        return present;
    }

    public static <T extends Enum<T>> boolean expectingEnumParam(char variable, DataPacket packet, Class<T> e, Consumer<T> ifPresent) {
        boolean present = packet.getPacketVariable(Character.valueOf(variable)) instanceof DataTypeString;
        if (present) {
            String name = ((DataTypeString)packet.getPacketVariable((Character)Character.valueOf((char)variable))).value;
            try {
                T found = Enum.valueOf(e, name.toUpperCase());
                ifPresent.accept(found);
            }
            catch (IllegalArgumentException | NullPointerException exception) {
                return false;
            }
        }
        return present;
    }

    public static <T extends Enum<T>> boolean expectingEnumParam(char variable, DataPacket packet, Function<String, T> mapping, Consumer<T> ifPresent) {
        boolean present = packet.getPacketVariable(Character.valueOf(variable)) instanceof DataTypeString;
        if (present) {
            Enum found = (Enum)mapping.apply(((DataTypeString)packet.getPacketVariable((Character)Character.valueOf((char)variable))).value);
            if (found != null) {
                ifPresent.accept(found);
            } else {
                present = false;
            }
        }
        return present;
    }

    @Nullable
    public static DataPacket handleCallback(DataPacket packet, Function<String, IDataType> mapper) {
        DataPacket sent = new DataPacket();
        for (Map.Entry<Character, IDataType> entry : packet.variables.entrySet()) {
            IDataType reply;
            if (entry.getKey().charValue() == 'c' || !(entry.getValue() instanceof DataTypeString) || (reply = mapper.apply(entry.getValue().valueToString())) == null) continue;
            sent.setVariable(entry.getKey(), reply);
        }
        return sent.hasAnyVariables() ? sent : null;
    }
}

