/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.operations.advanced_arithmetic;

import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;

public class DataOperationPower
extends DataOperation {
    public DataOperationPower() {
        this.name = "power";
        this.allowedTypes = new Class[]{IDataTypeNumeric.class, IDataTypeNumeric.class};
        this.expectedResult = IDataTypeNumeric.class;
    }

    @Override
    public IDataType execute(DataPacket packet, DataTypeExpression data) {
        IDataTypeNumeric t1 = packet.getVarInType(IDataTypeNumeric.class, data.getArgument(0));
        IDataTypeNumeric t2 = packet.getVarInType(IDataTypeNumeric.class, data.getArgument(1));
        if (t1 instanceof DataTypeFloat || t2 instanceof DataTypeFloat) {
            return new DataTypeFloat(Math.round(Math.pow(t1.floatValue(), t2.floatValue())));
        }
        return new DataTypeInteger((int)Math.round(Math.pow(t1.intValue(), t2.intValue())));
    }
}

