/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic;

import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;

public class DataOperationDivide
extends DataOperation {
    public DataOperationDivide() {
        this.name = "divide";
        this.expression = "/";
        this.allowedTypes = new Class[]{IDataTypeNumeric.class, IDataTypeNumeric.class};
        this.expectedResult = IDataTypeNumeric.class;
    }

    @Override
    public IDataType execute(DataPacket packet, DataTypeExpression data) {
        IDataTypeNumeric t1 = packet.getVarInType(IDataTypeNumeric.class, data.getArgument(0));
        IDataTypeNumeric t2 = packet.getVarInType(IDataTypeNumeric.class, data.getArgument(1));
        if (t2.floatValue() == 0.0f) {
            return t1 instanceof DataTypeInteger ? new DataTypeInteger(Integer.MAX_VALUE) : new DataTypeFloat(Float.MAX_VALUE);
        }
        if (t1 instanceof DataTypeFloat || t2 instanceof DataTypeFloat) {
            return new DataTypeFloat(t1.floatValue() / t2.floatValue());
        }
        return new DataTypeInteger(t1.intValue() / t2.intValue());
    }
}

