/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.operations.array;

import java.util.ArrayList;
import java.util.Arrays;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeArray;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataOperationPush
extends DataOperation {
    public DataOperationPush() {
        this.name = "array_push";
        this.allowedTypes = new Class[]{DataTypeArray.class, IDataType.class};
        this.params = new String[]{"array", "inserted"};
        this.expectedResult = DataTypeArray.class;
    }

    @Override
    public IDataType execute(DataPacket packet, DataTypeExpression data) {
        DataTypeArray array = packet.getVarInType(DataTypeArray.class, data.getArgument(0));
        IDataType pushed = data.getArgument(1);
        for (int tries = 0; pushed instanceof DataTypeAccessor && tries < 32; ++tries) {
            pushed = ((DataTypeAccessor)pushed).getRealValue(packet);
        }
        IDataType[] arr = array.value;
        ArrayList<IDataType> iDataTypes = new ArrayList<IDataType>(Arrays.asList(arr));
        iDataTypes.add(pushed);
        array.value = iDataTypes.toArray(new IDataType[0]);
        return array;
    }
}

