/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.operations.cryptographer;

import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.operations.cryptographer.Cryptographer;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeEncrypted;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataOperationDecryptNumber
extends DataOperation {
    public DataOperationDecryptNumber() {
        this.name = "decrypt_number";
        this.allowedTypes = new Class[]{DataTypeEncrypted.class, DataTypeString.class};
        this.params = new String[]{"message", "password"};
        this.expectedResult = DataTypeInteger.class;
    }

    @Override
    @Nonnull
    public IDataType execute(DataPacket packet, DataTypeExpression data) {
        byte[] encrypted = (byte[])packet.getVarInType(DataTypeEncrypted.class, (IDataType)data.getArgument((int)0)).value.clone();
        DataTypeString t2 = packet.getVarInType(DataTypeString.class, data.getArgument(1));
        String password = t2.valueToString();
        String decrypted = Cryptographer.decryptToString(encrypted, password.getBytes(StandardCharsets.UTF_8));
        return new DataTypeInteger(Integer.parseInt(decrypted));
    }
}

