/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.operations.cryptographer;

import javax.annotation.Nonnull;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.operations.cryptographer.Cryptographer;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeEncrypted;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeExpression;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeString;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataOperationEncryptNumber
extends DataOperation {
    public DataOperationEncryptNumber() {
        this.name = "encrypt_number";
        this.allowedTypes = new Class[]{DataTypeInteger.class, DataTypeString.class};
        this.params = new String[]{"number", "password"};
        this.expectedResult = DataTypeEncrypted.class;
    }

    @Override
    @Nonnull
    public IDataType execute(DataPacket packet, DataTypeExpression data) {
        DataTypeInteger t1 = packet.getVarInType(DataTypeInteger.class, data.getArgument(0));
        DataTypeString t2 = packet.getVarInType(DataTypeString.class, data.getArgument(1));
        String msg = t1.valueToString();
        String password = t2.valueToString();
        byte[] bytes = Cryptographer.encrypt(msg, password);
        return new DataTypeEncrypted(bytes);
    }
}

