/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.pol.instructions;

import java.util.ArrayList;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLComputerMemory;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLKeywords;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLProcess;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLScript;
import pl.pabilo8.immersiveintelligence.api.data.pol.POLTerminal;

public class POLInstructionGroup
extends POLScript.POLInstruction {
    private final ArrayList<POLScript.POLInstruction> instructionSet;

    public POLInstructionGroup(ArrayList<POLScript.POLInstruction> set) {
        super(set.stream().map(POLScript.POLInstruction::getExecutionTime).mapToInt(Integer::intValue).sum());
        this.instructionSet = set;
    }

    @Override
    public void execute(POLComputerMemory memory, POLTerminal terminal, POLProcess polProcess, int executionTime) {
        if (executionTime < 0 || executionTime > this.instructionSet.size() - 1) {
            return;
        }
        int time = 0;
        for (POLScript.POLInstruction instruction : this.instructionSet) {
            if (time >= executionTime) {
                instruction.execute(memory, terminal, polProcess, executionTime);
                break;
            }
            time += instruction.getExecutionTime();
        }
    }

    @Override
    public POLKeywords getKeyword() {
        return POLKeywords.BEGIN;
    }
}

