/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.radio;

import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.radio.IRadioDevice;
import pl.pabilo8.immersiveintelligence.common.IIUtils;

public class RadioNetwork {
    public static RadioNetwork INSTANCE = new RadioNetwork();
    ArrayList<IRadioDevice> devices = new ArrayList();
    ArrayList<IRadioDevice> toRemove = new ArrayList();

    public boolean addDevice(IRadioDevice pos) {
        if (!this.devices.contains(pos)) {
            this.devices.add(pos);
            return true;
        }
        return false;
    }

    public boolean removeDevice(IRadioDevice pos) {
        if (!this.toRemove.contains(pos)) {
            this.toRemove.add(pos);
            return true;
        }
        return false;
    }

    public void clearDevices() {
        this.devices.clear();
    }

    public ArrayList<IRadioDevice> getDevices() {
        return this.devices;
    }

    public void sendPacket(DataPacket packet, IRadioDevice sender, ArrayList<IRadioDevice> list) {
        if (this.toRemove.size() > 0) {
            list.addAll(this.toRemove);
            this.devices.removeAll(this.toRemove);
        }
        if (!list.contains(sender)) {
            sender.onRadioSend(packet);
            list.add(sender);
        }
        for (IRadioDevice dev : this.getDevices()) {
            if (list.contains(dev) || dev.getFrequency() != sender.getFrequency() || !this.distanceCheck(sender, dev) || !dev.onRadioReceive(packet)) continue;
            list.add(dev);
            INSTANCE.sendPacket(packet, dev, list);
        }
    }

    public void sendPacketItem() {
    }

    public boolean distanceCheck(IRadioDevice device1, IRadioDevice device2) {
        float range1 = device1.getRange() * device1.getWeatherRangeDecrease();
        float range2 = device2.getRange() * device2.getWeatherRangeDecrease();
        return IIUtils.getDistanceBetweenPos((BlockPos)device1.getDevicePosition(), (BlockPos)device2.getDevicePosition(), true) <= (double)((range1 + range2) / 2.0f);
    }
}

