/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeIterable;

public class DataTypeEncrypted
implements IDataTypeIterable {
    public byte[] value;

    public DataTypeEncrypted(byte[] data) {
        this.value = new byte[data.length];
        System.arraycopy(data, 0, this.value, 0, data.length);
    }

    public DataTypeEncrypted() {
    }

    @Override
    public String getName() {
        return "encrypted";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "ie.manual.entry.empty"}};
    }

    @Override
    public String valueToString() {
        if (this.value == null || this.value.length == 0) {
            return "00";
        }
        StringBuilder s = new StringBuilder();
        for (byte b : this.value) {
            s.append(String.format("%02X", b));
        }
        return s.delete(s.length() - 2, s.length() - 1).toString();
    }

    @Override
    public void setDefaultValue() {
        this.value = new byte[0];
    }

    @Override
    public void valueFromNBT(NBTTagCompound nbt) {
        this.value = nbt.func_74770_j("Values");
    }

    @Override
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        nbt.func_74773_a("Values", this.value);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 5901685;
    }
}

