/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import pl.pabilo8.immersiveintelligence.api.data.DataOperations;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.operations.DataOperation;
import pl.pabilo8.immersiveintelligence.api.data.operations.arithmetic.DataOperationAdd;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeAccessor;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataTypeExpression
implements IDataType {
    public IDataType[] data;
    DataOperation operation;
    char requiredVariable = (char)32;

    public DataTypeExpression(IDataType[] data, DataOperation operation, char requiredVariable) {
        this.data = data;
        this.operation = operation;
        this.requiredVariable = requiredVariable;
    }

    public IDataType getArgument(int index) {
        return this.data[index % this.data.length];
    }

    public DataOperation getOperation() {
        return this.operation;
    }

    public char getRequiredVariable() {
        return this.requiredVariable;
    }

    public void setOperation(@Nonnull DataOperation operation) {
        int i;
        this.operation = operation;
        IDataType[] newData = new IDataType[operation.allowedTypes.length];
        if (this.data != null) {
            for (i = 0; i < Math.min(operation.allowedTypes.length, this.data.length); ++i) {
                IDataType t1 = this.getArgument(i);
                if (t1.getClass() != DataTypeAccessor.class && !operation.allowedTypes[i].isAssignableFrom(t1.getClass())) continue;
                newData[i] = t1;
            }
        }
        for (i = 0; i < operation.allowedTypes.length; ++i) {
            if (newData[i] != null) continue;
            newData[i] = DataPacket.getVarInstance(operation.allowedTypes[i]);
        }
        this.data = newData;
    }

    public void setRequiredVariable(char requiredVariable) {
        this.requiredVariable = requiredVariable;
    }

    public DataTypeExpression() {
    }

    public IDataType getValue(DataPacket packet) {
        return this.operation.execute(packet, this);
    }

    @Override
    @Nonnull
    public String getName() {
        return "expression";
    }

    @Override
    @Nonnull
    public String valueToString() {
        if (this.operation.expression != null) {
            return String.format(this.operation.expression, Arrays.stream(this.data).map(IDataType::valueToString).toArray());
        }
        return this.operation.name;
    }

    @Override
    public void setDefaultValue() {
        this.operation = new DataOperationAdd();
        this.requiredVariable = (char)32;
        this.data = new IDataType[this.operation.allowedTypes.length];
        for (int i = 0; i < this.operation.allowedTypes.length; ++i) {
            this.data[i] = DataPacket.getVarInstance(this.operation.allowedTypes[i]);
        }
    }

    @Override
    public void valueFromNBT(NBTTagCompound nbt) {
        this.setDefaultValue();
        this.operation = DataOperations.getOperationInstance(nbt.func_74779_i("Operation"));
        this.requiredVariable = nbt.func_74779_i("requiredVariable").charAt(0);
        this.data = new IDataType[this.operation.allowedTypes.length];
        for (int i = 0; i < this.operation.allowedTypes.length; ++i) {
            this.data[i] = DataPacket.getVarFromNBT(nbt.func_74775_l("Value" + (i + 1)));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        nbt.func_74778_a("Operation", this.operation.name);
        nbt.func_74778_a("requiredVariable", String.valueOf(this.requiredVariable));
        for (int i = 0; i < this.operation.allowedTypes.length; ++i) {
            nbt.func_74782_a("Value" + (i + 1), (NBTBase)this.data[i].valueToNBT());
        }
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 2772404;
    }
}

