/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeInteger;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;

public class DataTypeFloat
implements IDataTypeNumeric {
    public float value;

    public DataTypeFloat(float i) {
        this.value = i;
    }

    public DataTypeFloat() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "float";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "0.0"}, {"ie.manual.entry.min_value", String.valueOf(Float.MIN_VALUE)}, {"ie.manual.entry.max_value", String.valueOf(Float.MAX_VALUE)}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        return String.valueOf(this.value);
    }

    @Override
    public void setDefaultValue() {
        this.value = 0.0f;
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        this.value = n.func_74760_g("Value");
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        nbt.func_74776_a("Value", this.value);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 879464;
    }

    @Override
    public DataTypeInteger asInt() {
        return new DataTypeInteger((int)this.value);
    }

    @Override
    public DataTypeFloat asFloat() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof IDataTypeNumeric && ((IDataTypeNumeric)obj).floatValue() == this.value;
    }
}

