/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;

public class DataTypeFluidStack
implements IDataType {
    @Nullable
    public FluidStack value;

    public DataTypeFluidStack(FluidStack i) {
        this.value = i.copy();
    }

    public DataTypeFluidStack() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "fluidstack";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "ie.manual.entry.empty"}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        if (this.value == null || this.value.getFluid() == null) {
            return "Empty";
        }
        return String.format("%d*%s%s", this.value.amount, this.value.getLocalizedName(), this.value.tag != null ? this.value.tag.toString() : "");
    }

    @Override
    public void setDefaultValue() {
        this.value = null;
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        this.value = FluidStack.loadFluidStackFromNBT((NBTTagCompound)n.func_74775_l("Value"));
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        if (this.value != null) {
            NBTTagCompound fluid_nbt = new NBTTagCompound();
            this.value.writeToNBT(fluid_nbt);
            nbt.func_74782_a("Value", (NBTBase)fluid_nbt);
        }
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 534320;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataTypeFluidStack && (this.value == null ? ((DataTypeFluidStack)obj).value == null : this.value.isFluidStackIdentical(((DataTypeFluidStack)obj).value));
    }
}

