/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeFloat;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeNumeric;

public class DataTypeInteger
implements IDataTypeNumeric {
    public int value;

    public DataTypeInteger(int i) {
        this.value = i;
    }

    public DataTypeInteger() {
    }

    @Override
    @Nonnull
    public String getName() {
        return "integer";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "0"}, {"ie.manual.entry.min_value", String.valueOf(Integer.MIN_VALUE)}, {"ie.manual.entry.max_value", String.valueOf(Integer.MAX_VALUE)}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        return String.valueOf(this.value);
    }

    @Override
    public void setDefaultValue() {
        this.value = 0;
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        this.value = n.func_74762_e("Value");
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        nbt.func_74768_a("Value", this.value);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 2519854;
    }

    @Override
    public DataTypeInteger asInt() {
        return this;
    }

    @Override
    public DataTypeFloat asFloat() {
        return new DataTypeFloat(this.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof IDataTypeNumeric && ((IDataTypeNumeric)obj).intValue() == this.value;
    }
}

