/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.data.types;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataTypeIterable;

public class DataTypeMap
implements IDataTypeIterable {
    private HashMap<IDataType, IDataType> values;

    public DataTypeMap(IDataType key, IDataType value) {
        this.setDefaultValue();
        this.values.put(key, value);
    }

    public DataTypeMap() {
    }

    public DataTypeMap put(IDataType key, IDataType value) {
        if (this.values.size() < 255) {
            this.values.put(key, value);
        }
        return this;
    }

    @Nonnull
    public IDataType getValue(IDataType key) {
        return this.values.getOrDefault(key, new DataTypeNull());
    }

    @Nonnull
    public IDataType getKey(IDataType value) {
        return this.values.entrySet().stream().filter(e -> ((IDataType)e.getValue()).equals(value)).map(Map.Entry::getKey).findFirst().orElse(new DataTypeNull());
    }

    @Override
    @Nonnull
    public String getName() {
        return "map";
    }

    @Override
    @Nonnull
    public String[][] getTypeInfoTable() {
        return new String[][]{{"ie.manual.entry.def_value", "ie.manual.entry.empty"}, {"ie.manual.entry.max_length", "255"}};
    }

    @Override
    @Nonnull
    public String valueToString() {
        return this.values.toString();
    }

    @Override
    public void setDefaultValue() {
        this.values = new HashMap();
    }

    @Override
    public void valueFromNBT(NBTTagCompound n) {
        this.setDefaultValue();
        NBTTagList l = n.func_150295_c("Entries", 10);
        for (NBTBase b : l) {
            NBTTagCompound c;
            if (!(b instanceof NBTTagCompound) || !(c = (NBTTagCompound)b).func_74764_b("Key") || !c.func_74764_b("Value")) continue;
            this.values.put(DataPacket.getVarFromNBT(c.func_74775_l("Key")), DataPacket.getVarFromNBT(c.func_74775_l("Value")));
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound valueToNBT() {
        NBTTagCompound nbt = this.getHeaderTag();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<IDataType, IDataType> entry : this.values.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("Key", (NBTBase)entry.getKey().valueToNBT());
            tag.func_74782_a("Value", (NBTBase)entry.getValue().valueToNBT());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Entries", (NBTBase)list);
        return nbt;
    }

    @Override
    public int getTypeColour() {
        return 5069076;
    }
}

