/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import pl.pabilo8.immersiveintelligence.api.utils.vehicles.IUpgradableMachine;

public class MachineUpgrade {
    private static final List<MachineUpgrade> registeredUpgrades = new ArrayList<MachineUpgrade>();
    protected String name;
    protected ResourceLocation icon;
    private int progress = 0;
    private int steps = 1;
    private final List<IngredientStack> requiredStacks = new ArrayList<IngredientStack>();

    public MachineUpgrade(String name, ResourceLocation icon) {
        this.name = name;
        this.icon = icon;
        registeredUpgrades.add(this);
    }

    @Nullable
    public static MachineUpgrade getUpgradeByID(String id) {
        return registeredUpgrades.stream().filter(machineUpgrade -> machineUpgrade.name.equals(id)).findFirst().orElse(null);
    }

    public MachineUpgrade addStack(IngredientStack stack) {
        this.requiredStacks.add(stack);
        return this;
    }

    public MachineUpgrade setRequiredProgress(int progress) {
        this.progress = progress;
        return this;
    }

    public MachineUpgrade setRequiredSteps(int steps) {
        this.steps = steps;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public List<IngredientStack> getRequiredStacks() {
        return this.requiredStacks;
    }

    public static List<MachineUpgrade> getUpgradesFromNBT(NBTTagCompound tag) {
        ArrayList<MachineUpgrade> upgrades = new ArrayList<MachineUpgrade>();
        for (MachineUpgrade machineUpgrade : registeredUpgrades) {
            if (!tag.func_74764_b(machineUpgrade.name)) continue;
            upgrades.add(machineUpgrade);
        }
        return upgrades;
    }

    public static List<MachineUpgrade> getMatchingUpgrades(IUpgradableMachine machine) {
        return registeredUpgrades.stream().filter(machine::upgradeMatches).collect(Collectors.toList());
    }

    public int getProgressRequired() {
        return this.progress;
    }

    public int getSteps() {
        return this.steps;
    }
}

