/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils.minecart;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.InvWrapper;
import pl.pabilo8.immersiveintelligence.api.utils.minecart.IMinecartBlockPickable;

public abstract class EntityMinecartCrateBase
extends EntityMinecartContainer
implements IMinecartBlockPickable {
    public EntityMinecartCrateBase(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartCrateBase(World worldIn, Vec3d vv) {
        super(worldIn, vv.field_72450_a, vv.field_72448_b, vv.field_72449_c);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.itemHandler = new InvWrapper((IInventory)this){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !EntityMinecartCrateBase.this.isIECrate() || IEApi.isAllowedInCrate((ItemStack)stack);
            }
        };
    }

    protected abstract Block getCarriedBlock();

    protected abstract int getBlockMetaID();

    public abstract boolean isIECrate();

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public IBlockState func_180457_u() {
        return this.getCarriedBlock().func_176203_a(this.getBlockMetaID());
    }

    public int func_94085_r() {
        return 8;
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void func_94095_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack cart = new ItemStack(Items.field_151143_au, 1);
            ItemStack drop2 = new ItemStack(this.getCarriedBlock(), 1, this.getBlockMetaID());
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.func_145818_k_()) {
                nbt.func_74778_a("name", this.func_95999_t());
            }
            this.writeInventoryNBT(nbt);
            drop2.func_77982_d(nbt);
            this.func_70099_a(drop2, 1.0f);
            this.func_70099_a(cart, 1.0f);
            this.func_70106_y();
        }
    }

    @Override
    public Tuple<ItemStack, EntityMinecart> getBlockForPickup() {
        ItemStack drop2 = new ItemStack(this.getCarriedBlock(), 1, this.getBlockMetaID());
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeInventoryNBT(nbt);
        drop2.func_77982_d(nbt);
        NBTTagCompound nbt2 = new NBTTagCompound();
        this.func_70014_b(nbt2);
        this.func_70106_y();
        EntityMinecartEmpty ent = new EntityMinecartEmpty(this.field_70170_p);
        ent.func_70020_e(nbt2);
        this.field_70170_p.func_72838_d((Entity)ent);
        ent.func_70020_e(nbt2);
        return new Tuple((Object)drop2, (Object)ent);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack(this.getCarriedBlock(), 1, this.getBlockMetaID());
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.func_145818_k_()) {
            nbt.func_74778_a("name", this.func_95999_t());
        }
        this.writeInventoryNBT(nbt);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Override
    public void setMinecartBlock(ItemStack stack) {
        if (stack.func_77942_o()) {
            assert (stack.func_77978_p() != null);
            this.readInventoryNBT(stack.func_77978_p());
            String s = ItemNBTHelper.getString((ItemStack)stack, (String)"name");
            if (!s.isEmpty()) {
                this.func_96094_a(s);
            }
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184288_f(playerIn);
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    private void writeInventoryNBT(NBTTagCompound nbt) {
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.extractItem(i, this.itemHandler.getStackInSlot(i).func_190916_E(), true);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("inventory", (NBTBase)invList);
    }

    void readInventoryNBT(NBTTagCompound nbt) {
        NonNullList stacks = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)this.func_70302_i_());
        for (int i = 0; i < stacks.size(); ++i) {
            this.itemHandler.extractItem(i, Integer.MAX_VALUE, false);
            this.itemHandler.insertItem(i, (ItemStack)stacks.get(i), false);
        }
    }
}

