/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils.minecart;

import blusunrize.immersiveengineering.api.energy.immersiveflux.IFluxReceiver;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import pl.pabilo8.immersiveintelligence.api.utils.minecart.EntityMinecartII;

public abstract class EntityMinecartEnergyContainer
extends EntityMinecartII
implements IFluxReceiver {
    MinecartEnergyStorage energyStorage = new MinecartEnergyStorage(this.getEnergyCapacity(), this.getMaxReceive(), this.getMaxExtract(), 0);
    private static final DataParameter<Integer> dataMarkerEnergy = EntityDataManager.func_187226_a(EntityMinecartEnergyContainer.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMinecartEnergyContainer(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartEnergyContainer(World worldIn, Vec3d vv) {
        super(worldIn, vv);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarkerEnergy, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateStorage(true);
        } else if (this.field_70173_aa % 200 == 0) {
            this.updateStorage(false);
        }
    }

    protected void updateStorage(boolean b) {
        if (b) {
            this.energyStorage.setEnergyStored((Integer)this.field_70180_af.func_187225_a(dataMarkerEnergy));
        } else {
            this.field_70180_af.func_187227_b(dataMarkerEnergy, (Object)this.energyStorage.getEnergyStored());
        }
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.readEnergyFromNBT(compound);
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.writeEnergyToNBT(compound);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isTeslaCharged() {
        return false;
    }

    public boolean isInfinite() {
        return false;
    }

    public abstract int getEnergyCapacity();

    public abstract int getMaxReceive();

    public abstract int getMaxExtract();

    @Override
    void writeNBTToStack(NBTTagCompound nbt) {
        this.writeEnergyToNBT(nbt);
    }

    @Override
    void readFromStack(ItemStack stack) {
        this.readEnergyFromNBT(ItemNBTHelper.getTag((ItemStack)stack));
    }

    public void writeEnergyToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("energyStorage", this.energyStorage.getEnergyStored());
    }

    public void readEnergyFromNBT(NBTTagCompound nbt) {
        this.energyStorage.setEnergyStored(nbt.func_74762_e("energyStorage"));
    }

    public int receiveEnergy(@Nullable EnumFacing from, int energy, boolean simulate) {
        return this.energyStorage.receiveEnergy(energy, simulate);
    }

    public int getEnergyStored(@Nullable EnumFacing from) {
        return this.isInfinite() ? Integer.MAX_VALUE : this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(@Nullable EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(@Nullable EnumFacing from) {
        return true;
    }

    public class MinecartEnergyStorage
    extends EnergyStorage {
        public MinecartEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
            super(capacity, maxReceive, maxExtract, energy);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int i;
            int n = i = EntityMinecartEnergyContainer.this.isInfinite() ? Integer.MAX_VALUE : super.extractEnergy(maxExtract, simulate);
            if (!simulate && i != 0) {
                EntityMinecartEnergyContainer.this.updateStorage(false);
            }
            return i;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int i;
            int n = i = EntityMinecartEnergyContainer.this.isInfinite() ? 0 : super.receiveEnergy(maxReceive, simulate);
            if (!simulate && i != 0) {
                EntityMinecartEnergyContainer.this.updateStorage(false);
            }
            return i;
        }

        public void setEnergyStored(int energy) {
            this.energy = energy;
        }
    }
}

