/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils.minecart;

import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import pl.pabilo8.immersiveintelligence.api.utils.minecart.EntityMinecartII;
import pl.pabilo8.immersiveintelligence.api.utils.tools.IAdvancedTextOverlay;

public abstract class EntityMinecartFluidContainer
extends EntityMinecartII
implements IAdvancedTextOverlay {
    public FluidTank tank = new FluidTank(this.getTankCapacity());
    SidedFluidHandler fluidHandler = new SidedFluidHandler(this, null);
    private static final DataParameter<NBTTagCompound> dataMarkerFluid = EntityDataManager.func_187226_a(EntityMinecartFluidContainer.class, (DataSerializer)DataSerializers.field_192734_n);

    public EntityMinecartFluidContainer(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartFluidContainer(World worldIn, Vec3d vv) {
        super(worldIn, vv);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarkerFluid, (Object)new NBTTagCompound());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateTank(true);
        }
    }

    protected void updateTank(boolean b) {
        if (b) {
            this.readTank((NBTTagCompound)this.field_70180_af.func_187225_a(dataMarkerFluid));
        } else {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeTank(tag, false);
            this.field_70180_af.func_187227_b(dataMarkerFluid, (Object)tag);
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.readTank(compound);
        if (!this.field_70170_p.field_72995_K) {
            this.updateTank(false);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        this.writeTank(compound, false);
        if (!this.field_70170_p.field_72995_K) {
            this.updateTank(false);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public void readTank(NBTTagCompound nbt) {
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
        this.tank.setCapacity(this.getTankCapacity());
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)player.func_184586_b(hand));
        if (f != null) {
            if (f.getFluid().isGaseous(f) && !this.isGasAllowed()) {
                ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.noGasAllowed", new Object[0])});
                return EnumActionResult.FAIL;
            }
            if (f.getFluid().getTemperature(f) >= this.getMaxTemperature()) {
                ChatUtils.sendServerNoSpamMessages((EntityPlayer)player, (ITextComponent[])new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.tooHot", new Object[0])});
                return EnumActionResult.FAIL;
            }
        }
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public abstract boolean isGasAllowed();

    public abstract int getMaxTemperature();

    public abstract int getTankCapacity();

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND))) {
            String s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    @Override
    void writeNBTToStack(NBTTagCompound nbt) {
        this.writeTank(nbt, true);
    }

    @Override
    void readFromStack(ItemStack stack) {
        this.readTank(ItemNBTHelper.getTag((ItemStack)stack));
    }

    static class SidedFluidHandler
    implements IFluidHandler {
        EntityMinecartFluidContainer barrel;
        EnumFacing facing;

        SidedFluidHandler(EntityMinecartFluidContainer barrel, EnumFacing facing) {
            this.barrel = barrel;
            this.facing = facing;
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int i = this.barrel.tank.fill(resource, doFill);
            if (i > 0) {
                this.barrel.updateTank(false);
            }
            return i;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack f = this.barrel.tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0) {
                this.barrel.updateTank(false);
            }
            return f;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.barrel.tank.getTankProperties();
        }
    }
}

