/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils.minecart;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import pl.pabilo8.immersiveintelligence.api.utils.minecart.IMinecartBlockPickable;

public abstract class EntityMinecartII
extends EntityMinecart
implements IMinecartBlockPickable {
    public EntityMinecartII(World worldIn) {
        super(worldIn);
    }

    public EntityMinecartII(World worldIn, Vec3d vv) {
        super(worldIn, vv.field_72450_a, vv.field_72448_b, vv.field_72449_c);
    }

    protected abstract Block getCarriedBlock();

    protected abstract int getBlockMetaID();

    abstract void writeNBTToStack(NBTTagCompound var1);

    abstract void readFromStack(ItemStack var1);

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public IBlockState func_180457_u() {
        return this.getCarriedBlock().func_176203_a(this.getBlockMetaID());
    }

    public int func_94085_r() {
        return 8;
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void func_94095_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack cart = new ItemStack(Items.field_151143_au, 1);
            ItemStack block = new ItemStack(this.getCarriedBlock(), 1, this.getBlockMetaID());
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.func_145818_k_()) {
                nbt.func_74778_a("name", this.func_95999_t());
            }
            this.writeNBTToStack(nbt);
            block.func_77982_d(nbt);
            this.func_70099_a(block, 1.0f);
            this.func_70099_a(cart, 1.0f);
            this.func_70106_y();
        }
    }

    @Override
    public Tuple<ItemStack, EntityMinecart> getBlockForPickup() {
        ItemStack stack = new ItemStack(this.getCarriedBlock(), 1, this.getBlockMetaID());
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNBTToStack(nbt);
        stack.func_77982_d(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("name", this.func_95999_t());
        }
        NBTTagCompound nbt2 = new NBTTagCompound();
        this.func_70014_b(nbt2);
        this.func_70106_y();
        EntityMinecartEmpty ent = new EntityMinecartEmpty(this.field_70170_p);
        ent.func_70020_e(nbt2);
        this.field_70170_p.func_72838_d((Entity)ent);
        ent.func_70020_e(nbt2);
        return new Tuple((Object)stack, (Object)ent);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = new ItemStack(this.getCarriedBlock(), 1, this.getBlockMetaID());
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNBTToStack(nbt);
        stack.func_77982_d(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("name", this.func_95999_t());
        }
        return stack;
    }

    @Override
    public void setMinecartBlock(ItemStack stack) {
        if (stack.func_77942_o()) {
            assert (stack.func_77978_p() != null);
            this.readFromStack(stack);
        }
    }
}

