/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.utils.tools;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IRarity;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IISkinHandler;

public interface ISkinnable {
    default public String getSkinnableCurrentSkin(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"contributorSkin");
    }

    default public void applySkinnableSkin(ItemStack stack, String skinName) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"contributorSkin", (String)skinName);
    }

    default public boolean isValidSkin(String skin) {
        return !skin.isEmpty() && IISkinHandler.specialSkins.containsKey(skin);
    }

    default public void addSkinTooltip(@Nonnull ItemStack stack, @Nonnull List<String> tooltip) {
        String skin = this.getSkinnableCurrentSkin(stack);
        if (IISkinHandler.isValidSkin(skin)) {
            IISkinHandler.IISpecialSkin s = IISkinHandler.specialSkins.get(skin);
            tooltip.add(s.rarity.field_77937_e + I18n.func_135052_a((String)String.format("skin.%1$s.%2$s.name", "immersiveintelligence", skin), (Object[])new Object[0]));
            tooltip.add(IIUtils.getItalicString(I18n.func_135052_a((String)String.format("skin.%1$s.%2$s.desc", "immersiveintelligence", skin), (Object[])new Object[0])));
        }
    }

    @Nullable
    default public IRarity getSkinRarity(@Nonnull ItemStack stack) {
        String skin = this.getSkinnableCurrentSkin(stack);
        if (IISkinHandler.isValidSkin(skin)) {
            return IISkinHandler.getSkin((String)skin).rarity;
        }
        return null;
    }

    public String getSkinnableName();

    public String getSkinnableDefaultTextureLocation();
}

