/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsIE;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.bullets.AmmoRegistry;
import pl.pabilo8.immersiveintelligence.api.bullets.DamageBlockPos;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmo;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IAmmoCore;
import pl.pabilo8.immersiveintelligence.api.bullets.PenetrationRegistry;
import pl.pabilo8.immersiveintelligence.api.utils.ItemTooltipHandler;
import pl.pabilo8.immersiveintelligence.api.utils.MachineUpgrade;
import pl.pabilo8.immersiveintelligence.client.model.ModelIIBase;
import pl.pabilo8.immersiveintelligence.client.util.font.IIFontRenderer;
import pl.pabilo8.immersiveintelligence.client.util.font.IIFontRendererCustomGlyphs;
import pl.pabilo8.immersiveintelligence.client.util.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.simple.BlockIIMetalBase;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityBullet;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.BlockIIMultiblock;

@SideOnly(value=Side.CLIENT)
public class IIClientUtils {
    @SideOnly(value=Side.CLIENT)
    public static IIFontRenderer fontRegular;
    @SideOnly(value=Side.CLIENT)
    public static IIFontRendererCustomGlyphs fontEngineerTimes;
    @SideOnly(value=Side.CLIENT)
    public static IIFontRendererCustomGlyphs fontNormung;
    @SideOnly(value=Side.CLIENT)
    public static IIFontRendererCustomGlyphs fontKaiser;
    @SideOnly(value=Side.CLIENT)
    public static IIFontRendererCustomGlyphs fontTinkerer;

    @SideOnly(value=Side.CLIENT)
    public static void drawStringCentered(FontRenderer fontRenderer, String string, int x, int y, int w, int h, int colour) {
        fontRenderer.func_78276_b(string, x + w / 2 - fontRenderer.func_78256_a(string) / 2, y + h, colour);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringCenteredScaled(FontRenderer fontRenderer, String string, int x, int y, int w, int h, float scale, int colour) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + ((float)(w / 2) - (float)fontRenderer.func_78256_a(string) * scale / 2.0f)), (float)(y + h), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_78276_b(string, 0, 0, colour);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBlockBreak(WorldClient world, float partialTicks, DamageBlockPos ... positions) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        TextureManager tex = Minecraft.func_71410_x().field_71446_o;
        EntityPlayerSP player = ClientUtils.mc().field_71439_g;
        double posX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double posY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double posZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        tex.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)1);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        buf.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buf.func_178969_c(-posX, -posY, -posZ);
        buf.func_78914_f();
        for (DamageBlockPos pos : positions) {
            IBlockState state = world.func_180495_p((BlockPos)pos);
            int progress = 9 - (int)MathHelper.func_76131_a((float)(pos.damage * 10.0f), (float)0.0f, (float)10.0f);
            if (progress < 0 || state.func_185904_a() == Material.field_151579_a) continue;
            Block block = state.func_177230_c();
            TileEntity te = world.func_175625_s((BlockPos)pos);
            boolean shouldOmit = block instanceof BlockIIMultiblock;
            if (!shouldOmit) {
                boolean bl = shouldOmit = te != null && te.canRenderBreaking();
            }
            if (shouldOmit) continue;
            brd.func_175020_a(state, (BlockPos)pos, ClientUtils.destroyBlockIcons[progress], (IBlockAccess)world);
        }
        tes.func_78381_a();
        buf.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179120_a((int)768, (int)774, (int)1, (int)1);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static void drawArmorBar(int x, int y, int w, int h, float progress) {
        IIClientUtils.drawGradientBar(x, y, w, h, -808464433, 0xCFCFCFC, progress);
    }

    public static void drawPowerBar(int x, int y, int w, int h, float progress) {
        IIClientUtils.drawGradientBar(x, y, w, h, -4909824, -10482944, progress);
    }

    public static void drawGradientBar(int x, int y, int w, int h, int color1, int color2, float progress) {
        int stored = (int)((float)h * progress);
        ClientUtils.drawGradientRect((int)x, (int)(y + (h - stored)), (int)(x + w), (int)(y + h), (int)color1, (int)color2);
    }

    @SideOnly(value=Side.CLIENT)
    public static void bindTexture(ResourceLocation path) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(path);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRope(BufferBuilder buff, double x, double y, double z, double xx, double yy, double zz, double xdiff, double zdiff) {
        buff.func_181662_b(x + xdiff, y, z - zdiff).func_187315_a(0.0, 0.0).func_181675_d();
        buff.func_181662_b(xx + xdiff, yy, zz - zdiff).func_187315_a(0.0, 1.0).func_181675_d();
        buff.func_181662_b(xx - xdiff, yy, zz + zdiff).func_187315_a(0.125, 1.0).func_181675_d();
        buff.func_181662_b(x - xdiff, y, z + zdiff).func_187315_a(0.125, 0.0).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFace(BufferBuilder buff, double x, double y, double z, double xx, double yy, double zz, double u, double uu, double v, double vv) {
        buff.func_181662_b(x, y, z).func_187315_a(u, v).func_181675_d();
        buff.func_181662_b(x, yy, z).func_187315_a(u, vv).func_181675_d();
        buff.func_181662_b(xx, yy, zz).func_187315_a(uu, vv).func_181675_d();
        buff.func_181662_b(xx, y, zz).func_187315_a(uu, v).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawFluidBlock(@Nonnull FluidStack fs, boolean flowing, double x, double y, double z, double xx, double yy, double zz, boolean drawEnd) {
        IIClientUtils.bindTexture(TextureMap.field_110575_b);
        String tex = (flowing ? fs.getFluid().getFlowing(fs) : fs.getFluid().getStill(fs)).toString();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(tex);
        if (sprite != null) {
            int col = fs.getFluid().getColor(fs);
            double u = sprite.func_94209_e();
            double uu = sprite.func_94212_f();
            double v = sprite.func_94206_g();
            double vv = v + ((double)sprite.func_94210_h() - v) * Math.min(1.0, (yy - y) / (double)sprite.func_94216_b());
            double ux = u + (uu - u) * Math.min(1.0, (xx - x) / (double)sprite.func_94211_a());
            double uz = u + uu * Math.min(1.0, (zz - z) / (double)sprite.func_94211_a());
            GlStateManager.func_179131_c((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
            BufferBuilder buff = Tessellator.func_178181_a().func_178180_c();
            buff.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            IIClientUtils.drawFace(buff, x, yy, z, xx, y, z, u, ux, v, vv);
            IIClientUtils.drawFace(buff, x, yy, zz, xx, y, zz, u, ux, v, vv);
            IIClientUtils.drawFace(buff, x, yy, z, x, y, zz, u, ux, v, vv);
            IIClientUtils.drawFace(buff, xx, yy, z, xx, y, zz, u, ux, v, vv);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItemProgress(ItemStack stack1, ItemStack stack2, float progress, ItemCameraTransforms.TransformType type, Tessellator tessellator, float scale) {
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (progress == 0.0f) {
            ClientUtils.mc().func_175599_af().func_181564_a(stack1, type);
        } else if (progress == 1.0f) {
            ClientUtils.mc().func_175599_af().func_181564_a(stack2, type);
        } else {
            float h0 = -0.5f;
            float h1 = h0 + progress;
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            GL11.glEnable((int)2960);
            GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GlStateManager.func_179132_a((boolean)false);
            GL11.glStencilFunc((int)512, (int)1, (int)255);
            GL11.glStencilOp((int)7681, (int)7680, (int)7680);
            GL11.glStencilMask((int)255);
            GlStateManager.func_179086_m((int)1024);
            GlStateManager.func_179114_b((float)(90.0f - ClientUtils.mc().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179090_x();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            ClientUtils.renderBox((BufferBuilder)worldrenderer, (double)-0.5, (double)h0, (double)-0.5, (double)0.5, (double)h1, (double)0.5);
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
            GlStateManager.func_179114_b((float)(-(90.0f - ClientUtils.mc().func_175598_ae().field_78735_i)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179132_a((boolean)true);
            GL11.glStencilMask((int)0);
            GL11.glStencilFunc((int)514, (int)0, (int)255);
            ClientUtils.mc().func_175599_af().func_181564_a(stack1, type);
            GL11.glStencilFunc((int)514, (int)1, (int)255);
            ClientUtils.mc().func_175599_af().func_181564_a(stack2, type);
            GL11.glDisable((int)2960);
        }
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelRendererTurbo[] createConstructionModel(@Nullable MachineUpgrade upgrade, ModelIIBase model) {
        int partCount = model.parts.values().stream().mapToInt(modelRendererTurbos -> ((ModelRendererTurbo[])modelRendererTurbos).length).sum();
        if (upgrade != null) {
            upgrade.setRequiredSteps(partCount);
        }
        ModelRendererTurbo[] output = new ModelRendererTurbo[partCount];
        int i = 0;
        for (ModelRendererTurbo[] value : model.parts.values()) {
            Arrays.sort(value, (o1, o2) -> (int)(o1.field_78797_d - o2.field_78797_d));
            ModelRendererTurbo[] modelRendererTurboArray = value;
            int n = modelRendererTurboArray.length;
            for (int j = 0; j < n; ++j) {
                ModelRendererTurbo mod;
                output[i] = mod = modelRendererTurboArray[j];
                ++i;
            }
        }
        return output;
    }

    @SideOnly(value=Side.CLIENT)
    public static void createAmmoTooltip(IAmmo ammo, ItemStack stack, @Nullable World worldIn, List<String> tooltip) {
        tooltip.add(IIClientUtils.getFormattedBulletTypeName(ammo, stack));
        if (ItemTooltipHandler.addExpandableTooltip(42, "%s - Composition", tooltip)) {
            AmmoRegistry.EnumFuseTypes fuse = ammo.getFuseType(stack);
            IAmmoCore core = ammo.getCore(stack);
            AmmoRegistry.EnumCoreTypes coreType = ammo.getCoreType(stack);
            IAmmoComponent[] components = ammo.getComponents(stack);
            tooltip.add(IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[1], "Details:"));
            if (ammo.isProjectile()) {
                tooltip.add("\u29b3 " + I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.core", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_core_type." + coreType.func_176610_l()), (Object[])new Object[0]), IIUtils.getHexCol(core.getColour(), I18n.func_135052_a((String)("item.immersiveintelligence.bullet.component." + core.getName() + ".name"), (Object[])new Object[0]))}));
                tooltip.add(fuse.symbol + " " + I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.fuse", (Object[])new Object[]{I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_fuse." + fuse.func_176610_l()), (Object[])new Object[0])}));
            } else {
                tooltip.add("\u29b3 " + I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.core", (Object[])new Object[]{"", IIUtils.getHexCol(core.getColour(), I18n.func_135052_a((String)("item.immersiveintelligence.bullet.component." + core.getName() + ".name"), (Object[])new Object[0]))}));
            }
            tooltip.add("\u2696 " + I18n.func_135052_a((String)"desc.immersiveintelligence.bullets.mass", (Object[])new Object[]{Utils.formatDouble((double)ammo.getMass(stack), (String)"0.##")}));
            if (components.length > 0) {
                tooltip.add(IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[1], "Components:"));
                for (IAmmoComponent comp : components) {
                    tooltip.add("   " + comp.getTranslatedName());
                }
            }
        }
        if (ammo.isProjectile() && !ammo.isBulletCore(stack) && ItemTooltipHandler.addExpandableTooltip(29, "%s - Ballistics", tooltip)) {
            tooltip.add(IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[0], "Performance:"));
            tooltip.add(String.format("\u2295 Damage Dealt: %s", Float.valueOf(ammo.getDamage())));
            tooltip.add(String.format("\u29c1 Standard Velocity: %s B/s", Float.valueOf(ammo.getDefaultVelocity())));
            tooltip.add(IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[0], "Armor Penetration:"));
            float hardness = ammo.getCore(stack).getPenetrationHardness();
            AmmoRegistry.EnumCoreTypes coreType = ammo.getCoreType(stack);
            IIClientUtils.listPenetratedAmount(tooltip, ammo, hardness, coreType, Blocks.field_150359_w, 0);
            IIClientUtils.listPenetratedAmount(tooltip, ammo, hardness, coreType, Blocks.field_150364_r, 0);
            IIClientUtils.listPenetratedAmount(tooltip, ammo, hardness, coreType, (Block)IEContent.blockStoneDecoration, BlockTypes_StoneDecoration.CONCRETE_TILE.getMeta());
            IIClientUtils.listPenetratedAmount(tooltip, ammo, hardness, coreType, (Block)IEContent.blockStorage, BlockTypes_MetalsIE.STEEL.getMeta());
            IIClientUtils.listPenetratedAmount(tooltip, ammo, hardness, coreType, IIContent.blockMetalStorage, BlockIIMetalBase.Metals.TUNGSTEN.getMeta());
        }
    }

    private static void listPenetratedAmount(List<String> tooltip, IAmmo ammo, float penetrationHardness, AmmoRegistry.EnumCoreTypes coreType, Block block, int meta) {
        int penetratedAmount = IIClientUtils.getPenetratedAmount(ammo, penetrationHardness, coreType, block, meta);
        String displayName = new ItemStack(block, 1, meta).func_82833_r();
        if (penetratedAmount < 1) {
            tooltip.add(TextFormatting.RED + "\u2715 " + displayName);
        } else {
            tooltip.add(TextFormatting.DARK_GREEN + String.format("\u29b4 %s: %d B", displayName, penetratedAmount));
        }
    }

    private static int getPenetratedAmount(IAmmo ammo, float penetrationHardness, AmmoRegistry.EnumCoreTypes coreType, Block block, int meta) {
        PenetrationRegistry.IPenetrationHandler penHandler = PenetrationRegistry.getPenetrationHandler(block.func_176203_a(meta));
        double realDrag = 1.0 - (double)(0.01f * EntityBullet.DEV_SLOMO);
        float density = penHandler.getDensity();
        float hardness = block.field_149782_v;
        float force = 1.0f;
        int count = 0;
        int speed = (int)ammo.getDefaultVelocity();
        while ((double)force > 0.1) {
            float pen = penetrationHardness * coreType.getPenMod(penHandler.getPenetrationType());
            if (!(pen > hardness / density)) {
                return count;
            }
            penetrationHardness -= hardness * 16.0f / pen;
            if (++count % speed != 0) continue;
            force = (float)((double)force * realDrag);
            force = (float)((double)force * 0.85);
        }
        return count;
    }

    private static String getFormattedBulletTypeName(IAmmo ammo, ItemStack stack) {
        HashSet<AmmoRegistry.EnumComponentRole> collect = new HashSet<AmmoRegistry.EnumComponentRole>();
        if (ammo.getCoreType(stack).getRole() != null) {
            collect.add(ammo.getCoreType(stack).getRole());
        }
        collect.addAll(Arrays.stream(ammo.getComponents(stack)).map(IAmmoComponent::getRole).collect(Collectors.toSet()));
        StringBuilder builder = new StringBuilder();
        for (AmmoRegistry.EnumComponentRole enumComponentRole : collect) {
            if (enumComponentRole == AmmoRegistry.EnumComponentRole.GENERAL_PURPOSE) continue;
            builder.append(IIUtils.getHexCol(enumComponentRole.getColor(), I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + enumComponentRole.func_176610_l()), (Object[])new Object[0])));
            builder.append(" - ");
        }
        if (builder.toString().isEmpty()) {
            builder.append(I18n.func_135052_a((String)("desc.immersiveintelligence.bullet_type." + AmmoRegistry.EnumComponentRole.GENERAL_PURPOSE.func_176610_l()), (Object[])new Object[0]));
            builder.append(" - ");
        }
        builder.delete(builder.length() - 3, builder.length());
        if (stack.func_82837_s()) {
            builder.append(" ").append(TextFormatting.GRAY).append(stack.func_77973_b().func_77653_i(stack));
        }
        return builder.toString();
    }
}

