/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.fx;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashSet;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.fx.ParticleRenderer;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleAtomFog;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleAtomicBoomCore;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleAtomicBoomRing;
import pl.pabilo8.immersiveintelligence.client.fx.nuke.ParticleShockwave;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleBlockFragment;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleExplosion;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleFlame;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleFlareTrace;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleGasCloud;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleGunfire;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleTMTModel;
import pl.pabilo8.immersiveintelligence.client.fx.particles.ParticleTracer;
import pl.pabilo8.immersiveintelligence.client.util.tmt.ModelRendererTurbo;
import pl.pabilo8.immersiveintelligence.common.entity.bullet.EntityAtomicBoom;
import pl.pabilo8.immersiveintelligence.common.util.IIExplosion;

@SideOnly(value=Side.CLIENT)
public class ParticleUtils {
    @SideOnly(value=Side.CLIENT)
    public static ParticleRenderer particleRenderer = new ParticleRenderer();
    public static Supplier<Float> randFloat = Utils.RAND::nextFloat;
    public static Supplier<Double> randDouble = Utils.RAND::nextDouble;

    public static void spawnExplosionBoomFX(World world, Vec3d pos, float radius, float strength, boolean flaming, boolean damagesTerrain) {
        ParticleUtils.spawnShockwave(pos, radius, 0.75f * strength);
        if (radius < 6.0f) {
            ParticleUtils.spawnExplosionFX(pos, Vec3d.field_186680_a, radius * 1.85f);
        }
        HashSet<BlockPos> positions = new HashSet<BlockPos>(new IIExplosion(world, null, pos, radius, strength, flaming, true).generateAffectedBlockPositions());
        world.func_184148_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        for (BlockPos position : positions) {
            int i;
            IBlockState state = world.func_180495_p(position);
            Vec3d vecPos = new Vec3d((Vec3i)position).func_178787_e(ParticleUtils.getPositiveRand(randFloat));
            Vec3d vecMotion = vecPos.func_178788_d(pos);
            double d6 = vecMotion.func_72433_c();
            vecMotion = vecMotion.func_186678_a(1.0 / d6);
            double d7 = 0.5 / (d6 / (double)radius + 0.1);
            vecMotion = vecMotion.func_186678_a(d7 *= randDouble.get() * randDouble.get() + 0.3);
            ParticleUtils.spawnBlockFragmentFX(vecPos, vecMotion, 1.0f, state);
            ParticleUtils.spawnVanillaParticle(EnumParticleTypes.EXPLOSION_NORMAL, vecPos.func_178787_e(pos).func_186678_a(0.5), vecMotion);
            ParticleUtils.spawnVanillaParticle(EnumParticleTypes.SMOKE_NORMAL, vecPos, vecMotion);
            Vec3d vv = new Vec3d((Vec3i)position).func_178787_e(ParticleUtils.getRandXZ(randFloat));
            ParticleUtils.spawnExplosionFX(vv, Vec3d.field_186680_a, 2.0f);
            if (flaming) {
                for (i = 0; i < 7; ++i) {
                    vv = new Vec3d((Vec3i)position).func_178787_e(ParticleUtils.withY(ParticleUtils.getPositiveXZRand(randFloat), 0.0));
                    Vec3d motion = ParticleUtils.withY(ParticleUtils.getPositiveXZRand(randFloat).func_186678_a((double)strength), Utils.RAND.nextFloat() * 0.01f);
                    ParticleUtils.spawnFlameFX(vv, motion, 4.0f, 40 + 10 * i);
                    motion = ParticleUtils.withY(ParticleUtils.getPositiveXZRand(randFloat).func_186678_a((double)strength), Utils.RAND.nextFloat() * 0.01f);
                    ParticleUtils.spawnVanillaParticle(EnumParticleTypes.SMOKE_LARGE, vv, motion);
                }
            }
            for (i = 0; i < 4; ++i) {
                vv = new Vec3d((Vec3i)position).func_178787_e(ParticleUtils.getRandXZ(randFloat));
                ParticleUtils.spawnBlockFragmentFX(vv, ParticleUtils.withY(ParticleUtils.getRandXZ(randFloat).func_186678_a((double)strength * 0.0125), (double)(randFloat.get().floatValue() * strength) * 0.1), 1.0f, state);
            }
        }
    }

    private static Vec3d getPositiveRand(Supplier<Float> s) {
        return new Vec3d((double)s.get().floatValue(), (double)s.get().floatValue(), (double)s.get().floatValue());
    }

    private static Vec3d getPositiveXZRand(Supplier<Float> s) {
        return new Vec3d((double)s.get().floatValue(), 0.0, (double)s.get().floatValue());
    }

    private static Vec3d getRandXZ(Supplier<Float> s) {
        return new Vec3d((double)(Utils.RAND.nextFloat() - 0.5f), 0.0, (double)(Utils.RAND.nextFloat() - 0.5f)).func_186678_a(2.0);
    }

    public static void spawnBlockFragmentFX(Vec3d pos, Vec3d motion, float size, IBlockState state) {
        ParticleBlockFragment particle = new ParticleBlockFragment((World)ParticleUtils.getWorld(), pos, motion, size, state);
        particle.init();
        particleRenderer.addEffect(particle);
    }

    public static void spawnTracerFX(Vec3d pos, Vec3d motion, float size, int color) {
        ParticleTracer particle = new ParticleTracer((World)ParticleUtils.getWorld(), pos, motion, size, color);
        particleRenderer.addEffect(particle);
    }

    public static void spawnGunfireFX(Vec3d pos, Vec3d motion, float size) {
        ParticleGunfire particle = new ParticleGunfire((World)ParticleUtils.getWorld(), pos, motion, size);
        particleRenderer.addEffect(particle);
    }

    public static void spawnTMTModelFX(Vec3d pos, Vec3d motion, float size, ModelRendererTurbo model, ResourceLocation texture) {
        ParticleTMTModel particle = new ParticleTMTModel((World)ParticleUtils.getWorld(), pos, motion, size, model, texture);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    public static void spawnFlameFX(Vec3d pos, Vec3d motion, float size, int lifeTime) {
        ParticleFlame particle = new ParticleFlame((World)ParticleUtils.getWorld(), pos, motion, size, lifeTime);
        particleRenderer.addEffect(particle);
    }

    public static void spawnExplosionFX(Vec3d pos, Vec3d motion, float size) {
        ParticleExplosion particle = new ParticleExplosion((World)ParticleUtils.getWorld(), pos, motion, size);
        particleRenderer.addEffect(particle);
    }

    public static void spawnExplosionPhosphorusFX(Vec3d pos) {
        for (int i = 0; i < 40; ++i) {
            float level = (float)Math.floor((float)i / 10.0f);
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 10.0f * 360.0f).func_186678_a(0.25 * ((double)(4.0f / level) * 0.175));
            ParticleExplosion particle = new ParticleExplosion((World)ParticleUtils.getWorld(), pos.func_72441_c(0.0, 0.025 + (double)(level * 0.65f), 0.0), v, 4.0f);
            particleRenderer.addEffect(particle);
        }
    }

    public static void spawnFlameExplosion(Vec3d pos, float size, Random rand) {
        Vec3d v;
        int i = 0;
        while ((float)i < 20.0f * size) {
            v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 20.0f * 360.0f);
            ParticleCloud particle = (ParticleCloud)ParticleUtils.spawnVanillaParticle(EnumParticleTypes.CLOUD, pos, ParticleUtils.withY(v.func_186678_a(0.25), 0.125));
            if (particle != null) {
                particle.func_70538_b(rand.nextFloat() * 0.125f, rand.nextFloat() * 0.125f, 0.0f);
                particle.func_70541_f(2.5f);
                particle.func_187114_a(10);
            }
            ++i;
        }
        i = 0;
        while ((float)i < 100.0f * size) {
            v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 25.0f * 360.0f);
            float level = (float)Math.floor((float)i / 25.0f);
            ParticleUtils.spawnExplosionFX(pos.func_72441_c(0.0, 0.025 + (double)(level * 0.65f), 0.0), ParticleUtils.withY(v.func_186678_a(0.25 * ((double)(4.0f / level) * 0.175)), 0.0125), 8.0f * size);
            ++i;
        }
    }

    public static void spawnShockwave(Vec3d pos, float size, float speed) {
        int i = 0;
        while ((float)i < 50.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 50.0f * 360.0f);
            ParticleShockwave particle = new ParticleShockwave((World)ParticleUtils.getWorld(), pos, ParticleUtils.withY(v.func_186678_a((double)speed), -speed * 0.02f), size);
            particle.func_187114_a((int)(40.0f * (speed / 2.5f)));
            particleRenderer.addEffect(particle);
            ++i;
        }
    }

    public static void spawnGasCloud(Vec3d pos, float size, Fluid fluid) {
        Vec3d v = pos.func_178787_e(ParticleUtils.getPositiveXZRand(randFloat).func_186678_a((double)size));
        ParticleGasCloud particle = new ParticleGasCloud((World)ParticleUtils.getWorld(), v, size * 16.0f, fluid);
        particle.func_187114_a((int)(80.0f * size));
        particleRenderer.addEffect(particle);
    }

    public static void spawnFog(Vec3d pos, float size, float speed, float yspeed) {
        int i = 0;
        while ((float)i < 36.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 36.0f * 360.0f);
            ParticleAtomFog particle = new ParticleAtomFog((World)ParticleUtils.getWorld(), pos, ParticleUtils.withY(ParticleUtils.scaleXZ(v, speed), yspeed), size);
            particle.func_187114_a((int)(40.0f * (size / 20.0f)));
            particleRenderer.addEffect(particle);
            ++i;
        }
    }

    public static void spawnAtomicBoomCore(EntityAtomicBoom entity, Vec3d pos, float size, float speed, float yspeed) {
        int i = 0;
        while ((float)i < 36.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.5, 0.0, 0.0).func_178785_b((float)i / 36.0f * 360.0f);
            ParticleAtomicBoomCore particle = new ParticleAtomicBoomCore((World)ParticleUtils.getWorld(), pos.func_178787_e(ParticleUtils.withY(v, 0.0)), ParticleUtils.withY(ParticleUtils.scaleXZ(v, speed), yspeed), size);
            particle.func_187114_a((int)(120.0f * (size / 20.0f)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            ++i;
        }
    }

    public static void spawnAtomicBoomRing(EntityAtomicBoom entity, Vec3d pos, float size, float speed, float yspeed) {
        int i = 0;
        while ((float)i < 36.0f * (size / 20.0f)) {
            Vec3d v = new Vec3d(1.0, 0.0, 0.0).func_178785_b((float)i / 36.0f * 360.0f);
            ParticleAtomicBoomRing particle = new ParticleAtomicBoomRing((World)ParticleUtils.getWorld(), pos, ParticleUtils.withY(ParticleUtils.scaleXZ(v, speed), yspeed), size);
            particle.func_187114_a((int)(40.0f * (size / 20.0f)));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            ++i;
        }
    }

    public static void spawnFlareFX(Vec3d pos, int colour, float size) {
        ParticleGasCloud.ParticleFlareFlash particle = new ParticleGasCloud.ParticleFlareFlash((World)ParticleUtils.getWorld(), pos, colour, size * 6.0f);
        particle.func_187114_a(20);
        particleRenderer.addEffect(particle);
    }

    public static void spawnFlareTraceFX(Vec3d pos, int colour, float size) {
        ParticleFlareTrace particle = new ParticleFlareTrace((World)ParticleUtils.getWorld(), pos, size, colour, 125);
        particleRenderer.addEffect(particle);
    }

    private static WorldClient getWorld() {
        return ClientUtils.mc().field_71441_e;
    }

    private static Particle spawnVanillaParticle(EnumParticleTypes particle, Vec3d pos, Vec3d motion) {
        return ClientUtils.mc().field_71452_i.func_178927_a(particle.func_179348_c(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, new int[0]);
    }

    private static Vec3d scaleXZ(Vec3d vector, double scale) {
        return new Vec3d(vector.field_72450_a * scale, vector.field_72448_b, vector.field_72449_c * scale);
    }

    private static Vec3d withY(Vec3d vec3d, double y) {
        return new Vec3d(vec3d.field_72450_a, y, vec3d.field_72449_c);
    }
}

