/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.block;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.PackerHandler;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiLabelNoShadow;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiPackerTaskList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonDropdownList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonSwitch;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityPacker;
import pl.pabilo8.immersiveintelligence.common.gui.ContainerPacker;

public class GuiPacker
extends GuiIEContainerBase {
    private static final ResourceLocation TEXTURE_ICONS = new ResourceLocation("immersiveintelligence:textures/gui/emplacement_icons.png");
    private static final ResourceLocation TEXTURE_PACKER = new ResourceLocation("immersiveintelligence:textures/gui/packer.png");
    private static final ResourceLocation TEXTURE_PAGE = new ResourceLocation("immersiveintelligence:textures/gui/printed_page.png");
    TileEntityPacker tile;
    final SideResourceDisplay sideDisplay;
    private final ContainerPacker container;
    private GuiButtonIE buttonAdd;
    private GuiButtonIE buttonRemove;
    private GuiButtonIE buttonDuplicate;
    private GuiButtonIE buttonClear;
    private GuiButtonIE buttonSideInput;
    private GuiButtonIE buttonSideOutput;
    private GuiButtonState buttonRepeat;
    private GuiPackerTaskList taskList;
    private GuiButtonDropdownList putModeList;
    private GuiButtonSwitch switchOreDict;
    private GuiButtonSwitch switchNBT;
    private GuiButtonSwitch switchDirection;
    private GuiTextField textFieldAmount;

    public GuiPacker(EntityPlayer player, TileEntityPacker tile) {
        super((Container)new ContainerPacker(player, tile));
        this.field_146999_f = 336;
        this.field_147000_g = 211;
        this.tile = tile;
        this.container = (ContainerPacker)this.field_147002_h;
        this.container.ghostUpdateFunction = this::saveBasicData;
        this.sideDisplay = tile.hasUpgrade(IIContent.UPGRADE_PACKER_FLUID) ? new SideFluidDisplay(this) : (tile.hasUpgrade(IIContent.UPGRADE_PACKER_ENERGY) ? new SideEnergyDisplay(this) : new SideItemDisplay(this));
    }

    public void func_73866_w_() {
        PackerHandler.PackerTask task;
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.addLabel(5, 6, 78, 11, 657930, "Tasks");
        this.buttonAdd = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 0, 223));
        this.buttonRemove = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6 + 12, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 24, 223));
        this.buttonDuplicate = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6 + 24, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 48, 223));
        this.buttonClear = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 6 + 36, this.field_147009_r + 96 + 4 + 8, 12, 12, "", TEXTURE_PACKER.toString(), 72, 223));
        this.buttonRepeat = (GuiButtonState)this.func_189646_b((GuiButton)new GuiButtonState(this.field_146292_n.size(), this.field_147003_i + 72, this.field_147009_r + 5, 12, 12, "", this.tile.repeatActions, TEXTURE_PACKER.toString(), 0, 235, 0));
        this.taskList = (GuiPackerTaskList)this.func_189646_b(this.taskList == null ? new GuiPackerTaskList(this.field_146292_n.size(), this.field_147003_i + 6, this.field_147009_r + 19, 78, 84, this.tile.tasks, this::saveGuiToTask) : this.taskList);
        this.taskList.recalculateEntries();
        if (this.sideDisplay instanceof SideItemDisplay) {
            this.buttonSideInput = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + this.field_146999_f - 80, this.field_147009_r - 12, 39, 12, "Input", TEXTURE_PACKER.toString(), 0, 211));
            this.buttonSideOutput = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + this.field_146999_f - 40, this.field_147009_r - 12, 39, 12, "Output", TEXTURE_PACKER.toString(), 0, 211));
        } else {
            this.buttonSideOutput = null;
            this.buttonSideInput = null;
        }
        if (this.container.ghostSlot != null) {
            this.container.ghostSlot.field_75223_e = -2147483647;
            this.container.ghostSlot.field_75221_f = -2147483647;
            this.container.ghostSlot.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
        }
        if (this.taskList.selectedOption != -1 && (task = this.tile.tasks.get(this.taskList.selectedOption)) != null) {
            this.addLabel(84, 10, 168, 0, 657930, "Task: " + I18n.func_135052_a((String)("desc.immersiveintelligence.metal_multiblock1.packer.task." + task.actionType.getActionName(task.unpack)), (Object[])new Object[0])).func_175203_a();
            this.sideDisplay.initPage(task);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.taskList.selectedOption != -1) {
            this.textFieldAmount.func_146192_a(mouseX, mouseY, 0);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.taskList.selectedOption != -1) {
            this.textFieldAmount.func_146201_a(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        if (button == this.buttonRepeat) {
            this.tile.repeatActions = this.buttonRepeat.state;
            this.saveBasicData();
        } else if (button == this.buttonSideInput || button == this.buttonSideOutput) {
            this.sideDisplay.outputPage = button == this.buttonSideOutput;
            this.saveBasicData();
            this.func_73866_w_();
        } else if (button == this.taskList) {
            this.switchOreDict = null;
            this.switchNBT = null;
            this.func_73866_w_();
        } else if (button == this.buttonAdd) {
            this.tile.tasks.add(new PackerHandler.PackerTask(PackerHandler.PackerPutMode.ALL_POSSIBLE, this.sideDisplay.getActionType(), new IngredientStack("*")));
            this.saveBasicData();
            this.func_73866_w_();
        } else if (button == this.buttonRemove) {
            if (this.taskList.selectedOption != -1) {
                this.tile.tasks.remove(this.taskList.selectedOption);
                this.taskList.selectedOption = -1;
                this.saveBasicData();
                this.func_73866_w_();
            }
        } else if (button == this.buttonDuplicate) {
            if (this.taskList.selectedOption != -1) {
                this.tile.tasks.add(new PackerHandler.PackerTask(this.tile.tasks.get(this.taskList.selectedOption).toNBT()));
                this.saveBasicData();
                this.func_73866_w_();
            }
        } else if (button == this.buttonClear) {
            this.tile.tasks.clear();
            this.taskList.selectedOption = -1;
            this.saveBasicData();
            this.func_73866_w_();
        } else if (this.taskList.selectedOption != -1) {
            this.saveGuiToTask(this.taskList.selectedOption);
            if (!this.putModeList.dropped) {
                this.func_73866_w_();
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.saveBasicData();
    }

    protected void func_146976_a(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IIClientUtils.bindTexture(TEXTURE_PACKER);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 256, 122);
        this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 122, 0, 122, 176, 89);
        this.func_73729_b(this.field_147003_i + 256, this.field_147009_r, 176, 122, 80, 122);
        this.sideDisplay.draw(mx, my);
        if (this.taskList.selectedOption != -1) {
            IIClientUtils.bindTexture(TEXTURE_PAGE);
            this.func_73729_b(this.field_147003_i + 85, this.field_147009_r + 3, 0, 0, 84, 59);
            this.func_73729_b(this.field_147003_i + 85 + 84, this.field_147009_r + 3, 64, 0, 84, 59);
            this.func_73729_b(this.field_147003_i + 85, this.field_147009_r + 3 + 59, 0, 137, 84, 59);
            this.func_73729_b(this.field_147003_i + 85 + 84, this.field_147009_r + 3 + 59, 64, 137, 84, 59);
            IIClientUtils.bindTexture(TEXTURE_PACKER);
            if (this.textFieldAmount != null) {
                this.textFieldAmount.func_146194_f();
            }
            this.sideDisplay.drawPage(mx, my);
        }
    }

    public void func_73863_a(int mx, int my, float partial) {
        super.func_73863_a(mx, my, partial);
        this.func_191948_b(mx, my);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.buttonAdd.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.add", (Object[])new Object[0]));
        } else if (this.buttonRemove.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.remove", (Object[])new Object[0]));
        } else if (this.buttonDuplicate.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.duplicate", (Object[])new Object[0]));
        } else if (this.buttonClear.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.emplacement.clear", (Object[])new Object[0]));
        } else if (this.buttonSideInput != null && this.buttonSideInput.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.packer.side_input", (Object[])new Object[0]));
        } else if (this.buttonSideOutput != null && this.buttonSideOutput.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.packer.side_output", (Object[])new Object[0]));
        } else if (this.switchDirection != null && this.switchDirection.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.metal_multiblock1.packer.switch_direction", (Object[])new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, (int)mx, (int)my, (FontRenderer)this.field_146289_q, (int)(this.field_147003_i + this.field_146999_f), (int)-1);
            RenderHelper.func_74520_c();
        }
    }

    protected GuiButtonSwitch addSwitch(int x, int y, int textWidth, int textColor, int color1, int color2, boolean state, String name, boolean firstTime) {
        return (GuiButtonSwitch)this.func_189646_b((GuiButton)new GuiButtonSwitch(this.field_146292_n.size(), this.field_147003_i + x, this.field_147009_r + y, textWidth, 8, 18, 9, 18, 52, state, TEXTURE_ICONS, textColor, color1, color2, name, firstTime));
    }

    protected GuiLabelNoShadow addLabel(int x, int y, int textColor, String ... text) {
        return this.addLabel(x, y, 0, 0, textColor, text);
    }

    protected GuiLabelNoShadow addLabel(int x, int y, int w, int h, int textColor, String ... text) {
        GuiLabelNoShadow guiLabel = new GuiLabelNoShadow(this.field_146289_q, this.field_146293_o.size(), this.field_147003_i + x, this.field_147009_r + y, w, h, textColor);
        Arrays.stream(text).forEachOrdered(arg_0 -> ((GuiLabelNoShadow)guiLabel).func_175202_a(arg_0));
        this.field_146293_o.add(guiLabel);
        return guiLabel;
    }

    private void saveGuiToTask(int task) {
        if (task == -1) {
            return;
        }
        PackerHandler.PackerTask t = this.tile.tasks.get(task);
        t.mode = PackerHandler.PackerPutMode.values()[this.putModeList.selectedEntry];
        this.sideDisplay.saveTask(t);
    }

    private void saveBasicData() {
        if (this.taskList.selectedOption != -1) {
            this.saveGuiToTask(this.taskList.selectedOption);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tasks", (NBTBase)this.tile.writeTasks());
        tag.func_74757_a("repeatActions", this.buttonRepeat.state);
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync((TileEntityIEBase)this.tile, tag));
    }

    private static class SideEnergyDisplay
    extends SideResourceDisplay {
        public SideEnergyDisplay(GuiPacker gui) {
            super(gui);
        }

        @Override
        void draw(int mx, int my) {
            IIClientUtils.bindTexture(TEXTURE_ICONS);
            this.gui.func_73729_b(this.gui.field_147003_i + 308, this.gui.field_147009_r + 34, 0, 50, 18, 18);
            this.gui.func_73729_b(this.gui.field_147003_i + 308, this.gui.field_147009_r + 70, 0, 50, 18, 18);
        }

        @Override
        PackerHandler.PackerActionType getActionType() {
            return PackerHandler.PackerActionType.ENERGY;
        }

        @Override
        void saveTask(PackerHandler.PackerTask task) {
            super.saveTask(task);
        }

        @Override
        public void initPage(PackerHandler.PackerTask task) {
            super.initPage(task);
        }

        @Override
        public void drawPage(int mx, int my) {
        }
    }

    private static class SideFluidDisplay
    extends SideResourceDisplay {
        public SideFluidDisplay(GuiPacker gui) {
            super(gui);
        }

        @Override
        void draw(int mx, int my) {
            IIClientUtils.bindTexture(TEXTURE_ICONS);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12, 40, 0, 40, 40);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12, 40, 0, 40, 40);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12 + 40, 40, 19, 40, 20);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12 + 60, 40, 10, 40, 40);
            int hh = 0;
            for (FluidStack fluid : this.gui.tile.fluidTank.fluids) {
                int height = (int)((float)fluid.amount / (float)this.gui.tile.fluidTank.getCapacity() * 96.0f);
                ClientUtils.drawRepeatedFluidSprite((FluidStack)fluid, (float)(this.gui.field_147003_i + 264), (float)(this.gui.field_147009_r + 12 + 2 + 96 - (hh += height)), (float)40.0f, (float)height);
            }
            IIClientUtils.bindTexture(TEXTURE_ICONS);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12, 80, 0, 40, 40);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12 + 40, 80, 19, 40, 20);
            this.gui.func_73729_b(this.gui.field_147003_i + 264, this.gui.field_147009_r + 12 + 60, 80, 10, 40, 40);
            this.gui.func_73729_b(this.gui.field_147003_i + 308, this.gui.field_147009_r + 34, 0, 50, 18, 18);
            this.gui.func_73729_b(this.gui.field_147003_i + 308, this.gui.field_147009_r + 70, 0, 50, 18, 18);
        }

        @Override
        PackerHandler.PackerActionType getActionType() {
            return PackerHandler.PackerActionType.FLUID;
        }

        @Override
        void saveTask(PackerHandler.PackerTask task) {
            super.saveTask(task);
        }

        @Override
        public void initPage(PackerHandler.PackerTask task) {
            super.initPage(task);
        }

        @Override
        public void drawPage(int mx, int my) {
        }
    }

    private static class SideItemDisplay
    extends SideResourceDisplay {
        private int scroll = 0;
        private final int maxScroll = 18 * (int)(Math.floor(18.0) - 6.0);

        public SideItemDisplay(GuiPacker gui) {
            super(gui);
        }

        @Override
        void draw(int mx, int my) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int mouseChange = Mouse.getDWheel();
            if (Mouse.isButtonDown((int)0) && this.gui.func_146978_c(318, 7, 11, 108, mx, my)) {
                this.scroll = (int)((float)this.maxScroll * MathHelper.func_76131_a((float)((float)(my - this.gui.field_147009_r - 7) / 94.0f), (float)0.0f, (float)1.0f)) / 18 * 18;
            } else if (this.gui.func_146978_c(261, 5, 71, 112, mx, my)) {
                this.scroll -= Integer.signum(mouseChange) * 18;
            }
            this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)this.maxScroll);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            this.gui.func_73729_b(0, 0, 148, 224, 108, 12);
            GlStateManager.func_179121_F();
            this.gui.func_175174_a(this.gui.field_147003_i + 239 + 80, (float)(this.gui.field_147009_r + 8) + 92.0f * ((float)this.scroll / (float)this.maxScroll), 161, 211, 9, 14);
            int pageScroll = this.outputPage ? this.scroll + 108 + this.maxScroll : this.scroll;
            for (Slot slot : ((GuiPacker)this.gui).container.slots) {
                if (slot == null) continue;
                int j = slot.getSlotIndex() - 1;
                int x = j % 3 * 18;
                int y = j / 3 * 18 - pageScroll;
                if (y < 0 || y > 90) {
                    slot.field_75223_e = -2147483647;
                    slot.field_75221_f = -2147483647;
                    continue;
                }
                slot.field_75223_e = 264 + x;
                slot.field_75221_f = 8 + y;
                this.gui.func_73729_b(this.gui.field_147003_i + 184 + 80 - 1 + x, this.gui.field_147009_r + 8 - 1 + y, 48, 235, 18, 18);
            }
        }

        @Override
        PackerHandler.PackerActionType getActionType() {
            return PackerHandler.PackerActionType.ITEM;
        }

        @Override
        void saveTask(PackerHandler.PackerTask task) {
            int[] oreIDs;
            super.saveTask(task);
            IngredientStack is = null;
            ItemStack stack = ((GuiPacker)this.gui).container.ghostSlot.func_75211_c();
            if (((GuiPacker)this.gui).switchOreDict.state && !stack.func_190926_b() && (oreIDs = OreDictionary.getOreIDs((ItemStack)stack)).length > 0) {
                is = new IngredientStack(OreDictionary.getOreName((int)oreIDs[0]));
            }
            task.stack = is == null ? (stack.func_190926_b() ? new IngredientStack("*") : new IngredientStack(stack)) : is;
            task.stack.useNBT = ((GuiPacker)this.gui).switchNBT.state;
        }

        @Override
        public void initPage(PackerHandler.PackerTask task) {
            super.initPage(task);
            this.gui.addLabel(88, 26, 657930, "Item:");
            this.gui.switchOreDict = this.gui.switchOreDict == null ? this.gui.addSwitch(88, 78, 85, 0x1A1A1A, 11867392, 9825536, task.stack.oreName != null, "Uses OreDict", false) : (GuiButtonSwitch)this.gui.func_189646_b((GuiButton)this.gui.switchOreDict);
            this.gui.switchNBT = this.gui.switchNBT == null ? this.gui.addSwitch(88, 90, 85, 0x1A1A1A, 11867392, 9825536, task.stack.useNBT, "NBT Sensitive:", false) : (GuiButtonSwitch)this.gui.func_189646_b((GuiButton)this.gui.switchNBT);
            ((GuiPacker)this.gui).container.ghostSlot.field_75223_e = 150;
            ((GuiPacker)this.gui).container.ghostSlot.field_75221_f = 16;
            ((GuiPacker)this.gui).container.ghostSlot.field_75224_c.func_70299_a(0, task.stack.getExampleStack());
        }

        @Override
        public void drawPage(int mx, int my) {
            ClientUtils.drawSlot((int)(this.gui.field_147003_i + 150), (int)(this.gui.field_147009_r + 16), (int)16, (int)16, (int)128);
        }
    }

    private static abstract class SideResourceDisplay {
        protected final GuiPacker gui;
        protected boolean outputPage = false;

        public SideResourceDisplay(GuiPacker gui) {
            this.gui = gui;
        }

        abstract void draw(int var1, int var2);

        abstract PackerHandler.PackerActionType getActionType();

        void saveTask(PackerHandler.PackerTask task) {
            try {
                task.stack.inputSize = Integer.parseInt(this.gui.textFieldAmount.func_146179_b());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            task.unpack = ((GuiPacker)this.gui).switchDirection.state;
        }

        public void initPage(PackerHandler.PackerTask task) {
            this.gui.addLabel(88, 42, 657930, "Mode:");
            this.gui.putModeList = (GuiButtonDropdownList)this.gui.func_189646_b(new GuiButtonDropdownList(this.gui.field_146292_n.size(), this.gui.field_147003_i + 84 + 32 + 20, this.gui.field_147009_r + 10 + 6 + 20, 112, 20, PackerHandler.PackerPutMode.values().length, (String[])Arrays.stream(PackerHandler.PackerPutMode.values()).map(PackerHandler.PackerPutMode::func_176610_l).toArray(String[]::new)));
            this.gui.putModeList.setTranslationFunc(s -> I18n.func_135052_a((String)("desc.immersiveintelligence.metal_multiblock1.packer.mode." + s), (Object[])new Object[0]));
            ((GuiPacker)this.gui).putModeList.selectedEntry = task.mode.ordinal();
            this.gui.addLabel(88, 54, 657930, "Amount:");
            this.gui.addLabel(168, 54, 657930, "Expires After:");
            this.gui.textFieldAmount = new GuiTextField(this.gui.field_146292_n.size(), this.gui.field_146297_k.field_71466_p, this.gui.field_147003_i + 84 + 4, this.gui.field_147009_r + 10 + 6 + 10 + 32 + 1, 72, 14);
            this.gui.textFieldAmount.func_146180_a(task.mode == PackerHandler.PackerPutMode.ALL_POSSIBLE ? "*" : String.valueOf(task.stack.inputSize));
            this.gui.textFieldAmount.func_146184_c(task.mode != PackerHandler.PackerPutMode.ALL_POSSIBLE);
            this.gui.switchDirection = this.gui.switchDirection == null ? this.gui.addSwitch(232, 4, 85, 0x1A1A1A, 16758037, 5012401, task.unpack, "", false) : (GuiButtonSwitch)this.gui.func_189646_b((GuiButton)this.gui.switchDirection);
        }

        public abstract void drawPage(int var1, int var2);
    }
}

