/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.block.arithmetic_logic_machine;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.lib.manual.gui.GuiManual;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.ImmersiveIntelligence;
import pl.pabilo8.immersiveintelligence.client.ClientProxy;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.gui.ITabbedGui;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiLabelNoShadow;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiWidgetManualWrapper;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonItemAdvanced;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonTab;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityArithmeticLogicMachine;
import pl.pabilo8.immersiveintelligence.common.gui.ContainerArithmeticLogicMachine;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageBooleanAnimatedPartsSync;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageGuiNBT;

public class GuiArithmeticLogicMachineBase
extends GuiIEContainerBase
implements ITabbedGui {
    protected static final ResourceLocation TEXTURE_STORAGE = new ResourceLocation("immersiveintelligence:textures/gui/arithmetic_logic_machine_storage.png");
    protected static final ResourceLocation TEXTURE_EDIT = new ResourceLocation("immersiveintelligence:textures/gui/arithmetic_logic_machine_editing.png");
    protected static final ResourceLocation TEXTURE_VARIABLES = new ResourceLocation("immersiveintelligence:textures/gui/arithmetic_logic_machine_variables.png");
    private final IIGuiList thisGui;
    public final LinkedHashMap<GuiButton, IIGuiList> TABS = new LinkedHashMap();
    protected String title = I18n.func_135052_a((String)"tile.immersiveintelligence.metal_multiblock.arithmetic_logic_machine.name", (Object[])new Object[0]);
    private final ResourceLocation thisTexture;
    protected ClientProxy proxy = (ClientProxy)ImmersiveIntelligence.proxy;
    protected TileEntityArithmeticLogicMachine tile;
    public IItemHandler handler;
    protected InventoryPlayer playerInv;
    private GuiManual trueManual;
    public GuiWidgetManualWrapper sideManual = null;
    protected GuiButtonState manualButton;
    protected boolean preparedForChange = false;

    public GuiArithmeticLogicMachineBase(EntityPlayer player, TileEntityArithmeticLogicMachine tile, IIGuiList gui) {
        super(gui.containerFromTile.apply(player, (TileEntity)tile));
        this.thisTexture = gui == IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_STORAGE ? TEXTURE_STORAGE : (gui == IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_EDIT ? TEXTURE_EDIT : TEXTURE_VARIABLES);
        this.field_147000_g = 222;
        this.playerInv = player.field_71071_by;
        this.thisGui = gui;
        this.tile = tile;
        this.handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.refreshStoredData();
    }

    public void func_73866_w_() {
        IIPacketHandler.sendToServer(new MessageBooleanAnimatedPartsSync(true, 0, this.tile.func_174877_v()));
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.TABS.clear();
        super.func_73866_w_();
        this.refreshStoredData();
        this.addLabel(4, 8, 657930, this.title);
        this.addTab(IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_STORAGE, "storage_module");
        this.addItemTab(IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_0, 0);
        this.addItemTab(IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_1, 1);
        this.addItemTab(IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_2, 2);
        this.addItemTab(IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_3, 3);
        this.trueManual = ManualHelper.getManual().getGui();
        if (this.trueManual == null || this.trueManual instanceof GuiWidgetManualWrapper) {
            this.trueManual = new GuiManual(ManualHelper.getManual(), ManualHelper.getManual().texture);
        }
        this.sideManual = new GuiWidgetManualWrapper(this.trueManual, this.field_147003_i + this.field_146999_f - 20, this.field_147009_r, this.proxy.storedGuiData.func_74767_n("manual"));
        this.manualButton = (GuiButtonState)this.func_189646_b((GuiButton)new GuiButtonState(this.field_146292_n.size(), 0, this.field_147009_r + 56, 32, 18, "", this.proxy.storedGuiData.func_74767_n("manual"), TEXTURE_STORAGE.toString(), 176, 48, -1));
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.manualButton) {
            this.saveBasicData();
        } else if (this.TABS.containsKey(button)) {
            this.syncDataToServer();
            this.saveBasicData();
            this.preparedForChange = true;
            IIPacketHandler.sendToServer(new MessageGuiNBT(this.TABS.get(button), (TileEntity)this.tile));
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_146269_k() throws IOException {
        int mouseZ;
        int mouseX;
        boolean handled = false;
        if (this.sideManual.manualTime == 100 && IIUtils.isPointInRectangle(this.field_147003_i + this.field_146999_f, this.sideManual.y, this.sideManual.x + 146, this.sideManual.y + 198, mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c, mouseZ = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1)) {
            this.sideManual.func_146269_k();
            handled = true;
        }
        if (!handled) {
            super.func_146269_k();
        }
    }

    protected void func_184098_a(@Nullable Slot slotIn, int slotId, int mouseButton, @Nullable ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        if (slotIn instanceof ContainerArithmeticLogicMachine.CircuitSlot) {
            this.func_73866_w_();
        }
    }

    public void func_73863_a(int mx, int my, float partial) {
        super.func_73863_a(mx, my, partial);
        ArrayList<String> tooltip = this.getTooltip(mx, my);
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, (int)mx, (int)my, (FontRenderer)this.field_146289_q, (int)-1, (int)-1);
            RenderHelper.func_74520_c();
        }
    }

    public ArrayList<String> getTooltip(int mx, int my) {
        ArrayList<String> tooltip = new ArrayList<String>();
        this.TABS.keySet().stream().filter(GuiButton::func_146115_a).findFirst().ifPresent(tab -> tooltip.add(tab.field_146126_j));
        if (this.manualButton.func_146115_a()) {
            tooltip.add(I18n.func_135052_a((String)("desc.immersiveintelligence." + (this.manualButton.state ? "hide_manual_widget" : "show_manual_widget")), (Object[])new Object[0]));
        }
        return tooltip;
    }

    public void func_146281_b() {
        this.syncDataToServer();
        if (!this.preparedForChange) {
            IIPacketHandler.sendToServer(new MessageBooleanAnimatedPartsSync(false, 0, this.tile.func_174877_v()));
        }
        super.func_146281_b();
    }

    protected void func_146976_a(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.sideManual.setOpened(this.manualButton.state);
        this.manualButton.field_146128_h = this.field_147003_i + 176 + (int)(146.0f * ((float)this.sideManual.manualTime / 100.0f));
        this.sideManual.func_73863_a(mx, my, f);
        IIClientUtils.bindTexture(this.thisTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    void refreshStoredData() {
    }

    protected void syncDataToServer() {
        if (this.tile == null) {
            return;
        }
        this.sideManual.func_146281_b();
        GuiManual.activeManual = this.trueManual;
        this.trueManual.setSelectedEntry(this.sideManual.getSelectedEntry());
        this.trueManual.selectedCategory = this.sideManual.selectedCategory;
        this.trueManual.previousSelectedEntry = this.sideManual.previousSelectedEntry;
        this.trueManual.page = this.sideManual.page;
    }

    protected void addTab(IIGuiList gui, String name) {
        int vOffset = this.TABS.size() * 24;
        GuiButtonTab button = new GuiButtonTab(this.field_146292_n.size(), this.field_147003_i - 28, this.field_147009_r + 4 + vOffset, 28, 24, this.thisGui == gui ? 204 : 176, vOffset, TEXTURE_STORAGE, I18n.func_135052_a((String)("desc.immersiveintelligence." + name), (Object[])new Object[0]));
        this.TABS.put(button, gui);
        this.func_189646_b(button);
    }

    protected void addItemTab(IIGuiList gui, int slot) {
        int vOffset = this.TABS.size() * 24;
        if (!this.handler.getStackInSlot(slot).func_190926_b()) {
            GuiButtonItemAdvanced button = new GuiButtonItemAdvanced(this.field_146292_n.size(), this.field_147003_i - 28, this.field_147009_r + 4 + vOffset, 28, 24, TEXTURE_STORAGE, this.thisGui == gui ? 204 : 176, 24, this.handler.getStackInSlot(slot), 6, 2);
            this.TABS.put((GuiButton)button, gui);
            this.func_189646_b((GuiButton)button);
        }
    }

    protected GuiLabel addLabel(int x, int y, int textColor, String ... text) {
        return this.addLabel(x, y, 0, 0, false, textColor, text);
    }

    protected GuiLabel addLabel(int x, int y, int w, int h, boolean shadow, int textColor, String ... text) {
        GuiLabel guiLabel = shadow ? new GuiLabel(this.field_146289_q, this.field_146293_o.size(), this.field_147003_i + x, this.field_147009_r + y, w, h, textColor) : new GuiLabelNoShadow(this.field_146289_q, this.field_146293_o.size(), this.field_147003_i + x, this.field_147009_r + y, w, h, textColor);
        Arrays.stream(text).forEachOrdered(arg_0 -> ((GuiLabel)guiLabel).func_175202_a(arg_0));
        this.field_146293_o.add(guiLabel);
        return guiLabel;
    }

    public void saveBasicData() {
        ITabbedGui.super.saveBasicData(this.proxy, (TileEntity)this.tile);
        this.proxy.storedGuiData.func_74757_a("manual", this.manualButton.state);
    }

    protected static IIGuiList getPage(int page) {
        switch (page) {
            default: {
                return IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_0;
            }
            case 1: {
                return IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_1;
            }
            case 2: {
                return IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_2;
            }
            case 3: 
        }
        return IIGuiList.GUI_ARITHMETIC_LOGIC_MACHINE_VARIABLES_3;
    }
}

