/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.block.data_input_machine;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.gui.block.data_input_machine.GuiDataInputMachineBase;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonDataLetterList;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonII;
import pl.pabilo8.immersiveintelligence.client.gui.elements.data_editor.GuiDataEditor;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock0.tileentity.TileEntityDataInputMachine;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageGuiNBT;

public class GuiDataInputMachineEdit
extends GuiDataInputMachineBase {
    public char variableToEdit = (char)97;
    public IDataType dataType;
    public GuiButtonDataLetterList buttonLetter;
    public GuiButtonIE buttonApply;
    public GuiButtonIE buttonTypeNext;
    public GuiButtonIE buttonTypePrev;
    private GuiButtonII buttonVariableHelp;
    @Nullable
    private GuiDataEditor<? extends IDataType> editor = null;

    public GuiDataInputMachineEdit(EntityPlayer player, TileEntityDataInputMachine tile) {
        super(player, tile, IIGuiList.GUI_DATA_INPUT_MACHINE_EDIT);
        this.title = I18n.func_135052_a((String)"tile.immersiveintelligence.metal_multiblock.data_input_machine.edit", (Object[])new Object[0]);
        this.refreshStoredData();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(43, 40, 115, 0, false, 657930, I18n.func_135052_a((String)"desc.immersiveintelligence.variable_properties", (Object[])new Object[0])).func_175203_a();
        this.addLabel(61, 24, 657930, I18n.func_135052_a((String)"desc.immersiveintelligence.variable_type", (Object[])new Object[0]));
        this.addLabel(142 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + this.dataType.getName()), (Object[])new Object[0])), 24, MathHelper.func_180188_d((int)this.dataType.getTypeColour(), (int)0xCACACA), I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + this.dataType.getName()), (Object[])new Object[0]));
        this.buttonApply = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(this.field_146292_n.size(), this.field_147003_i + 96, this.field_147009_r + 121, 64, 12, I18n.func_135052_a((String)"desc.immersiveintelligence.variable_apply", (Object[])new Object[0]), TEXTURE_EDIT.toString(), 0, 222).setHoverOffset(64, 0));
        this.buttonVariableHelp = (GuiButtonII)this.func_189646_b((GuiButton)new GuiButtonII(this.field_146292_n.size(), this.field_147003_i + 152 - 10, this.field_147009_r + 15, 16, 16, String.format("immersiveintelligence:textures/gui/data_types/%s.png", this.dataType.getName()), 0.0f, 0.0f, 1.0f, 1.0f));
        this.buttonTypeNext = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(0, this.field_147003_i + 159, this.field_147009_r + 14 + 2, 8, 6, "", "immersiveintelligence:textures/gui/emplacement_icons.png", 128, 77).setHoverOffset(8, 0));
        this.buttonTypePrev = (GuiButtonIE)this.func_189646_b((GuiButton)new GuiButtonIE(0, this.field_147003_i + 159, this.field_147009_r + 14 + 10, 8, 6, "", "immersiveintelligence:textures/gui/emplacement_icons.png", 128, 83).setHoverOffset(8, 0));
        this.editor = null;
        for (Map.Entry<Class<? extends IDataType>, BiFunction<Integer, IDataType, GuiDataEditor<? extends IDataType>>> entry : GuiDataEditor.editors.entrySet()) {
            if (entry.getKey() != this.dataType.getClass()) continue;
            this.editor = (GuiDataEditor)this.func_189646_b(entry.getValue().apply(this.field_146292_n.size(), this.dataType));
            this.editor.setBounds(this.field_147003_i + 35, this.field_147009_r + 46, 131, 80);
            break;
        }
        this.buttonLetter = (GuiButtonDataLetterList)this.func_189646_b(new GuiButtonDataLetterList(this.field_146292_n.size(), this.field_147003_i + 42 - 10, this.field_147009_r + 14, false, this.variableToEdit, GuiButtonDataLetterList.ArrowsAlignment.LEFT));
        this.buttonLetter.setAvoidGetter(() -> this.list);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.editor != null) {
            this.editor.update();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.editor != null && this.editor.isFocused()) {
            this.editor.keyTyped(typedChar, keyCode);
        } else if (!this.buttonLetter.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.buttonLetter) {
            if (this.buttonLetter.selectedEntry != this.variableToEdit) {
                this.switchLetter();
            }
        } else if (button == this.buttonTypeNext || button == this.buttonTypePrev) {
            this.switchType(button == this.buttonTypeNext);
        } else if (button == this.buttonApply) {
            if (this.editor != null) {
                this.dataType = this.editor.outputType();
            }
            this.saveBasicData();
            this.syncDataToServer();
            this.preparedForChange = true;
            IIPacketHandler.sendToServer(new MessageGuiNBT(IIGuiList.GUI_DATA_INPUT_MACHINE_VARIABLES, (TileEntity)this.tile));
        } else if (button == this.buttonVariableHelp) {
            this.sideManual.selectedCategory = "ii_data";
            this.sideManual.setSelectedEntry("data_variable_types");
            this.sideManual.page = 0;
            String pp = "data_variable_types_" + this.dataType.getName();
            List entries = ManualHelper.getManual().manualContents.get((Object)"ii_data");
            Optional<ManualInstance.ManualEntry> first = entries.stream().filter(manualEntry -> manualEntry.getName().equals("data_variable_types")).findFirst();
            if (first.isPresent()) {
                IManualPage[] pages = first.get().getPages();
                int i = 0;
                for (IManualPage page : pages) {
                    if (page instanceof ManualPages && ReflectionHelper.getPrivateValue(ManualPages.class, (Object)((ManualPages)page), (String[])new String[]{"text"}).equals(pp)) {
                        this.sideManual.page = i;
                        break;
                    }
                    ++i;
                }
            }
            this.manualButton.state = true;
            this.sideManual.func_73866_w_();
        }
    }

    @Override
    public ArrayList<String> getTooltip(int mx, int my) {
        ArrayList<String> tooltip = super.getTooltip(mx, my);
        if (this.editor != null) {
            this.editor.getTooltip(tooltip, mx, my);
        }
        return tooltip;
    }

    @Override
    void refreshStoredData() {
        super.refreshStoredData();
        this.list = this.tile.storedData;
        if (this.positionEqual(this.proxy, (TileEntity)this.tile) && this.proxy.storedGuiData.func_74764_b("variableToEdit")) {
            this.variableToEdit = this.proxy.storedGuiData.func_74779_i("variableToEdit").charAt(0);
        }
        this.dataType = this.list.getPacketVariable(Character.valueOf(this.variableToEdit));
    }

    void switchType(boolean forward) {
        try {
            ArrayList<Class<? extends IDataType>> types = new ArrayList<Class<? extends IDataType>>(GuiDataEditor.editors.keySet());
            int i = IIUtils.cycleInt(forward, types.indexOf(this.dataType.getClass()), 0, types.size() - 1);
            this.list.setVariable(Character.valueOf(this.variableToEdit), new DataPacket().getVarInType(types.get(i), new DataTypeNull()));
            this.dataType = this.list.getPacketVariable(Character.valueOf(this.variableToEdit));
            this.dataType.setDefaultValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.syncDataToServer();
        this.func_73866_w_();
    }

    void switchLetter() {
        if (!this.list.variables.containsKey(Character.valueOf(this.buttonLetter.selectedEntry))) {
            this.list.setVariable(Character.valueOf(this.buttonLetter.selectedEntry), this.list.getPacketVariable(Character.valueOf(this.variableToEdit)));
            this.list.removeVariable(Character.valueOf(this.variableToEdit));
            this.variableToEdit = this.buttonLetter.selectedEntry;
        }
        this.syncDataToServer();
        this.func_73866_w_();
    }

    @Override
    protected void syncDataToServer() {
        this.proxy.storedGuiData.func_74778_a("variableToEdit", String.valueOf(this.variableToEdit));
        this.tile.storedData.setVariable(Character.valueOf(this.variableToEdit), this.dataType);
        super.syncDataToServer();
    }
}

