/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.block.emplacement;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiIEContainerBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.client.gui.ITabbedGui;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiElementProgressBar;
import pl.pabilo8.immersiveintelligence.client.gui.elements.GuiLabelNoShadow;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonSwitch;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiButtonTab;
import pl.pabilo8.immersiveintelligence.client.gui.elements.buttons.GuiSliderII;
import pl.pabilo8.immersiveintelligence.common.IIGuiList;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.block.multiblock.metal_multiblock1.tileentity.TileEntityEmplacement;
import pl.pabilo8.immersiveintelligence.common.gui.ContainerEmplacement;
import pl.pabilo8.immersiveintelligence.common.network.IIPacketHandler;
import pl.pabilo8.immersiveintelligence.common.network.messages.MessageGuiNBT;

public abstract class GuiEmplacement
extends GuiIEContainerBase
implements ITabbedGui {
    protected final ResourceLocation TEXTURE = new ResourceLocation("immersiveintelligence:textures/gui/emplacement.png");
    public final ResourceLocation TEXTURE_ICONS = new ResourceLocation("immersiveintelligence:textures/gui/emplacement_icons.png");
    protected final TileEntityEmplacement tile;
    protected String title = I18n.func_135052_a((String)"tile.immersiveintelligence.metal_multiblock1.emplacement.name", (Object[])new Object[0]);
    private final LinkedHashMap<GuiButtonTab, IIGuiList> TABS = new LinkedHashMap();
    private final IIGuiList thisGui;
    private GuiElementProgressBar barEnergy;
    private GuiElementProgressBar barArmor;

    public GuiEmplacement(EntityPlayer player, TileEntityEmplacement tile, IIGuiList gui) {
        super((Container)(gui == IIGuiList.GUI_EMPLACEMENT_STORAGE ? new ContainerEmplacement.ContainerEmplacementStorage(player, tile) : new ContainerEmplacement(player, tile)));
        this.tile = tile;
        this.thisGui = gui;
        this.field_146999_f = 240;
        this.field_147000_g = 238;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.TABS.clear();
        this.addTab(IIGuiList.GUI_EMPLACEMENT_STORAGE, "storage_module");
        this.addTab(IIGuiList.GUI_EMPLACEMENT_TASKS, "tasks_module");
        this.addTab(IIGuiList.GUI_EMPLACEMENT_STATUS, "status_module");
        this.addLabel(8, 10, 657930, this.title);
        this.barEnergy = GuiElementProgressBar.createEnergyBar(this.field_147003_i + 213, this.field_147009_r + 22, 7, 48);
        this.barArmor = GuiElementProgressBar.createArmorBar(this.field_147003_i + 222, this.field_147009_r + 22, 7, 48);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        ArrayList<String> tooltip = new ArrayList<String>();
        for (Map.Entry<GuiButtonTab, IIGuiList> entry : this.TABS.entrySet()) {
            if (!entry.getKey().func_146115_a()) continue;
            tooltip.add(entry.getKey().field_146126_j);
            break;
        }
        if (this.barEnergy.mouseOver(mouseX, mouseY)) {
            tooltip.add(IIUtils.getPowerLevelString(this.tile));
        }
        if (this.tile.currentWeapon != null && this.barArmor.mouseOver(mouseX, mouseY)) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveintelligence.tooltip.armor", (Object[])new Object[]{Float.valueOf(this.getHealth() * 100.0f)}));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, (int)(-this.field_147003_i + mouseX), (int)(-this.field_147009_r + mouseY), (FontRenderer)this.field_146289_q, (int)-1, (int)-1);
            RenderHelper.func_74520_c();
        }
    }

    private float getHealth() {
        return (float)this.tile.currentWeapon.getHealth() / (float)this.tile.currentWeapon.getMaxHealth();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiButtonTab) {
            this.syncDataToServer();
            IIPacketHandler.sendToServer(new MessageGuiNBT(this.TABS.get(button), (TileEntity)this.tile));
        }
    }

    protected void syncDataToServer() {
    }

    protected void func_146976_a(float partialTicks, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.barEnergy.draw((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null));
        if (this.tile.currentWeapon != null) {
            this.barArmor.draw(this.getHealth());
        }
    }

    protected void bindTexture() {
        this.field_146297_k.func_110434_K().func_110577_a(this.TEXTURE);
    }

    public void bindIcons() {
        this.field_146297_k.func_110434_K().func_110577_a(this.TEXTURE_ICONS);
    }

    protected void addTab(IIGuiList gui, String name) {
        int vOffset = this.TABS.size() * 24;
        GuiButtonTab button = new GuiButtonTab(this.field_146292_n.size(), this.field_147003_i - 28, this.field_147009_r + 4 + vOffset, 28, 24, this.thisGui == gui ? 28 : 0, 101 + vOffset, this.TEXTURE_ICONS, I18n.func_135052_a((String)("desc.immersiveintelligence." + name), (Object[])new Object[0]));
        this.TABS.put(button, gui);
        this.func_189646_b(button);
    }

    protected GuiButtonSwitch addSwitch(int x, int y, int textWidth, int textColor, int color1, int color2, boolean state, String name, boolean firstTime) {
        return (GuiButtonSwitch)this.func_189646_b((GuiButton)new GuiButtonSwitch(this.field_146292_n.size(), this.field_147003_i + x, this.field_147009_r + y, textWidth, 8, 18, 9, 18, 52, state, this.TEXTURE_ICONS, textColor, color1, color2, name, firstTime));
    }

    protected GuiButtonSwitch addSwitch(int x, int y, int textWidth, int textColor, int color1, int color2, boolean state, String name) {
        return this.addSwitch(x, y, textWidth, textColor, color1, color2, state, name, false);
    }

    protected GuiSliderII addSlider(int x, int y, int width, int textColor, float value, String name) {
        return (GuiSliderII)this.func_189646_b((GuiButton)new GuiSliderII(this.field_146292_n.size(), this.field_147003_i + x, this.field_147009_r + y, width, name, value, textColor));
    }

    protected GuiLabelNoShadow addLabel(int x, int y, int textColor, String ... text) {
        return this.addLabel(x, y, 0, 0, textColor, text);
    }

    protected GuiLabelNoShadow addLabel(int x, int y, int w, int h, int textColor, String ... text) {
        GuiLabelNoShadow guiLabel = new GuiLabelNoShadow(this.field_146289_q, this.field_146293_o.size(), this.field_147003_i + x, this.field_147009_r + y, w, h, textColor);
        Arrays.stream(text).forEachOrdered(arg_0 -> ((GuiLabelNoShadow)guiLabel).func_175202_a(arg_0));
        this.field_146293_o.add(guiLabel);
        return guiLabel;
    }
}

