/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.api.PackerHandler;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.common.IIUtils;

public class GuiPackerTaskList
extends GuiButton {
    private final ArrayList<PackerHandler.PackerTask> entries;
    private final Consumer<Integer> taskChange;
    private static final ResourceLocation TEXTURE_PACKER = new ResourceLocation("immersiveintelligence:textures/gui/packer.png");
    private long prevWheelNano = 0L;
    private int scroll;
    private int maxScroll;
    public int hoveredOption = -1;
    public int selectedOption = -1;

    public GuiPackerTaskList(int id, int x, int y, int w, int h, ArrayList<PackerHandler.PackerTask> entries, Consumer<Integer> taskChange) {
        super(id, x, y, w, h, "");
        this.entries = entries;
        this.taskChange = taskChange;
        this.recalculateEntries();
    }

    public void recalculateEntries() {
        this.maxScroll = Math.max(this.entries.size() - 4, 0) * 20;
    }

    public void setScrollPercent(float percent) {
        this.recalculateEntries();
        this.scroll = Math.round(MathHelper.func_76131_a((float)(percent * (float)this.maxScroll), (float)0.0f, (float)this.maxScroll));
    }

    public float getScrollPercent() {
        return (float)this.scroll / (float)this.maxScroll;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mx, int my, float partialTicks) {
        if (this.entries.size() > 0 && IIUtils.isPointInRectangle(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, mx, my)) {
            int mouseWheel = Mouse.getEventDWheel();
            if (mouseWheel != 0 && this.maxScroll > 0 && Mouse.getEventNanoseconds() != this.prevWheelNano) {
                this.prevWheelNano = Mouse.getEventNanoseconds();
                this.scroll -= Integer.signum(mouseWheel) * 10;
            }
            if (Mouse.isButtonDown((int)0) && IIUtils.isPointInRectangle(this.field_146128_h + this.field_146120_f - 11, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + (this.field_146121_g - 11), mx, my)) {
                float v = (float)(my - this.field_146129_i) / (float)this.field_146121_g;
                this.setScrollPercent(((float)(my - this.field_146129_i) + (v > 0.5f ? v / 20.0f : -v / 20.0f)) / (float)(this.field_146121_g - 11));
            }
            this.scroll = MathHelper.func_76125_a((int)this.scroll, (int)0, (int)this.maxScroll);
            this.hoveredOption = (int)Math.floor((float)(my + this.scroll - this.field_146129_i) / 20.0f);
            if (this.hoveredOption >= this.entries.size()) {
                this.hoveredOption = -1;
            }
        } else {
            this.hoveredOption = -1;
        }
        GlStateManager.func_179094_E();
        IIClientUtils.bindTexture(TEXTURE_PACKER);
        this.func_73729_b(this.field_146128_h + this.field_146120_f - 10, this.field_146129_i + (int)(this.getScrollPercent() * (float)(this.field_146121_g - 12)), 161, 211, 9, 14);
        this.scissor(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        int i = 0;
        for (PackerHandler.PackerTask entry : this.entries) {
            this.drawEntry(mc, this.field_146128_h, this.field_146129_i + i * 20 - this.scroll, i == this.hoveredOption, entry);
            ++i;
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
    }

    void drawEntry(Minecraft mc, int x, int y, boolean hovered, PackerHandler.PackerTask task) {
        GL11.glPushMatrix();
        GlStateManager.func_179140_f();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        IIClientUtils.bindTexture(TEXTURE_PACKER);
        this.func_73729_b(x, y, 96, 211, 65, 20);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)("desc.immersiveintelligence.metal_multiblock1.packer.task." + task.actionType.getActionName(task.unpack)), (Object[])new Object[0]), (float)(x + 2), (float)(y + 7), 657930, false);
        if (Objects.equals(task.stack.oreName, "*")) {
            boolean u = mc.field_71466_p.func_82883_a();
            mc.field_71466_p.func_78264_a(true);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + 47 + 5), (float)(y + 1), (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            mc.field_71466_p.func_78276_b("*", 0, 0, -557004);
            GlStateManager.func_179121_F();
            mc.field_71466_p.func_78264_a(u);
        } else {
            NonNullList ores;
            RenderHelper.func_74520_c();
            long rand = mc.field_71439_g.field_70173_aa;
            ItemStack stack = task.stack.stack;
            if (stack.func_190926_b() && task.stack.stackList != null && task.stack.stackList.size() > 0) {
                stack = (ItemStack)task.stack.stackList.get((int)(rand / 20L) % task.stack.stackList.size());
            }
            if (stack.func_190926_b() && task.stack.oreName != null && (ores = OreDictionary.getOres((String)task.stack.oreName)) != null) {
                for (ItemStack next : ores) {
                    if (!next.func_77981_g() || next.func_77960_j() != Short.MAX_VALUE) continue;
                    ores.remove(next);
                    NonNullList list = NonNullList.func_191196_a();
                    next.func_77973_b().func_150895_a(next.func_77973_b().func_77640_w(), list);
                    ores.addAll(list);
                }
                if (ores.size() > 0) {
                    stack = (ItemStack)ores.get((int)(rand / 20L) % ores.size());
                }
            }
            mc.func_175599_af().func_175042_a(stack, x + 47, y + 2);
            RenderHelper.func_74518_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void scissor(int x, int y, int xSize, int ySize) {
        GL11.glEnable((int)3089);
        ScaledResolution res = new ScaledResolution(ClientUtils.mc());
        y = ClientUtils.mc().field_71440_d - y * res.func_78325_e() - (ySize *= res.func_78325_e());
        GL11.glScissor((int)(x *= res.func_78325_e()), (int)y, (int)(xSize *= res.func_78325_e()), (int)ySize);
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        int s = this.selectedOption;
        if (IIUtils.isPointInRectangle(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f - 11, this.field_146129_i + this.field_146121_g, mx, my)) {
            this.selectedOption = this.selectedOption != this.hoveredOption ? this.hoveredOption : -1;
            this.taskChange.accept(s);
        }
        return this.selectedOption != s;
    }
}

