/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.item;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.util.font.IIFontRenderer;

public class GuiPrintedPage
extends GuiScreen {
    private static final Pattern patternHighlight = Pattern.compile("\\[(.+?)]");
    private static final Pattern patternBold = Pattern.compile("\\*\\*(.+?)\\*\\*");
    private static final Pattern patternItalic = Pattern.compile("\\*(.+?)\\*");
    private static final Pattern patternUnderline = Pattern.compile("__(.+?)__");
    private static final Pattern patternStrikethrough = Pattern.compile("~~(.+?)~~");
    private static final String PAGE_TEXTURE = "immersiveintelligence:textures/gui/printed_page.png";
    private int guiLeft = 0;
    private int guiTop = 0;
    private final FormattedTextLine[] lines;

    public GuiPrintedPage(EntityPlayer player, ItemStack heldStack, EnumHand hand) {
        String text = ItemNBTHelper.getString((ItemStack)heldStack, (String)"text").replace("<br>", "\n").replace("\\n", "\n");
        text = this.matchReplaceSimple(patternHighlight, text, TextFormatting.BOLD, TextFormatting.GOLD);
        text = this.matchReplaceSimple(patternBold, text, TextFormatting.BOLD);
        text = this.matchReplaceSimple(patternItalic, text, TextFormatting.ITALIC);
        text = this.matchReplaceSimple(patternUnderline, text, TextFormatting.UNDERLINE);
        text = this.matchReplaceSimple(patternStrikethrough, text, TextFormatting.STRIKETHROUGH);
        this.lines = (FormattedTextLine[])Arrays.stream(text.split("\n")).map(FormattedTextLine::new).toArray(FormattedTextLine[]::new);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 149) / 2;
        this.guiTop = (this.field_146295_m - 196) / 2;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_146276_q_();
        this.drawPage();
    }

    public void drawPage() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture((String)PAGE_TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 146, 196);
        int y = 24;
        for (FormattedTextLine line : this.lines) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.guiLeft + 8), (float)(this.guiTop + y), (float)0.0f);
            GlStateManager.func_179152_a((float)line.size, (float)line.size, (float)line.size);
            line.font.func_78279_b(line.text, 0, 0, (int)(141.0f / line.size), 657930);
            y = (int)((float)y + (float)line.font.func_78267_b(line.text, (int)(141.0f / line.size)) * line.size);
            GlStateManager.func_179121_F();
        }
    }

    private String matchReplaceSimple(Pattern pattern, String text, TextFormatting ... formats) {
        return this.matchReplace(pattern, text, (stringBuilder, matcher) -> {
            for (TextFormatting format : formats) {
                stringBuilder.append(format);
            }
            stringBuilder.append(matcher.group(1)).append(TextFormatting.RESET);
        });
    }

    private String matchReplace(Pattern pattern, String text, BiConsumer<StringBuilder, Matcher> operation) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = pattern.matcher(text);
        int i = 0;
        while (matcher.find()) {
            builder.append(text, i, matcher.start());
            operation.accept(builder, matcher);
            i = matcher.end();
        }
        builder.append(text.substring(i));
        return builder.toString();
    }

    private static class FormattedTextLine {
        private final IIFontRenderer font;
        private final String text;
        private final float size;

        public FormattedTextLine(String text) {
            String[] split = text.split(" ");
            IIFontRenderer font = IIClientUtils.fontRegular;
            float size = 1.0f;
            int removed = 0;
            for (String s : split) {
                if (s.startsWith("#")) {
                    switch (s.substring(1)) {
                        case "engineer_times": 
                        case "times": {
                            font = IIClientUtils.fontEngineerTimes;
                            break;
                        }
                        case "fraktur": 
                        case "kaiser": 
                        case "kaiser_fraktur": 
                        case "kaiserfraktur": {
                            font = IIClientUtils.fontKaiser;
                            break;
                        }
                        case "normung": 
                        case "bahnschrift": {
                            font = IIClientUtils.fontNormung;
                            break;
                        }
                        case "tinkerer": {
                            font = IIClientUtils.fontTinkerer;
                        }
                    }
                    continue;
                }
                if (!s.startsWith("@")) break;
                try {
                    size = Float.parseFloat(s.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (font != IIClientUtils.fontRegular) {
                ++removed;
            }
            if (size != 1.0f) {
                ++removed;
            }
            this.font = font;
            if (removed == 0) {
                this.text = text;
            } else {
                StringBuilder builder = new StringBuilder();
                for (int i = removed; i < split.length; ++i) {
                    builder.append(split[i]).append(" ");
                }
                this.text = builder.toString().trim();
            }
            this.size = size;
        }
    }
}

