/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.overlay;

import blusunrize.immersiveengineering.client.ClientUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.gui.overlay.GuiOverlayBase;
import pl.pabilo8.immersiveintelligence.client.util.CameraHandler;
import pl.pabilo8.immersiveintelligence.client.util.IIDrawUtils;

public class GuiOverlayZoom
extends GuiOverlayBase {
    @Override
    public boolean shouldDraw(EntityPlayer player, RayTraceResult mouseOver) {
        return CameraHandler.zoom != null;
    }

    @Override
    public void draw(EntityPlayer player, RayTraceResult mouseOver, int width, int height) {
        GlStateManager.func_179094_E();
        int resMin = Math.min(width, height);
        this.drawReticle(width, height, resMin, player);
        if (CameraHandler.zoom.getZoomSteps(CameraHandler.stack, player).length > 1) {
            this.drawZoomStepsBar(width, height, resMin, player);
        }
        GlStateManager.func_179121_F();
    }

    private void drawZoomStepsBar(int width, int height, int resMin, EntityPlayer player) {
        float[] steps = CameraHandler.zoom.getZoomSteps(CameraHandler.stack, player);
        assert (steps != null && steps.length >= 1);
        IIClientUtils.bindTexture(TEXTURE_IE_HUD);
        IIDrawUtils draw = IIDrawUtils.startTextured().setOffset(0.390625f * (float)resMin, 0.0f).drawTexRect(0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 0.25f, 0.34375f, 0.375f, 0.875f);
        int curStep = -1;
        float dist = 0.0f;
        float stepLength = 118.0f / (float)steps.length;
        float stepOffset = (stepLength - 7.0f) / 2.0f;
        draw.addOffset(0.87109375f * (float)resMin, 0.25f * (float)resMin + (5.0f + stepOffset) / 256.0f * (float)resMin);
        for (int i = 0; i < steps.length; ++i) {
            draw.drawTexRect(0.0f, (float)i * (stepLength / 256.0f * (float)resMin), 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375f, 0.375f, 0.375f, 0.40234375f);
            if (curStep != -1 && !(Math.abs(steps[i] - CameraHandler.fovZoom) < dist)) continue;
            curStep = i;
            dist = Math.abs(steps[i] - CameraHandler.fovZoom);
        }
        draw.addOffset(0.0234375f * (float)resMin, (float)curStep * stepLength / 256.0f * (float)resMin);
        draw.drawTexRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375f, 0.3828125f, 0.40234375f, 0.4296875f);
        draw.finish();
        ClientUtils.font().func_78276_b(1.0f / steps[curStep] + "x", (int)((float)resMin * 1.385f), (int)(0.390625f * (float)resMin), 0xFFFFFF);
    }

    private void drawReticle(int width, int height, int resMin, EntityPlayer player) {
        ResourceLocation overlay = CameraHandler.zoom.getZoomOverlayTexture(CameraHandler.stack, player);
        if (overlay == null) {
            return;
        }
        IIClientUtils.bindTexture(overlay);
        float progress = CameraHandler.zoom.getZoomProgress(CameraHandler.stack, player);
        float centerX = (float)(width - resMin) / 2.0f;
        float centerY = (float)(height - resMin) / 2.0f;
        IIDrawUtils draw = IIDrawUtils.startTexturedColored();
        GlStateManager.func_179147_l();
        if (resMin == width) {
            draw.drawTexColorRect(0.0f, 0.0f, (float)width, (float)((int)centerY + 1), 0.0f, 0.0f, 0.0f, progress, 0.0f, 0.0f, 0.0f, 0.0f);
            draw.drawTexColorRect(0.0f, (float)((int)centerY + resMin), (float)width, (float)((int)centerY + 1), 0.0f, 0.0f, 0.0f, progress, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            draw.drawTexColorRect(0.0f, 0.0f, (float)((int)centerX + 1), (float)height, 0.0f, 0.0f, 0.0f, progress, 0.0f, 0.0f, 0.0f, 0.0f);
            draw.drawTexColorRect((float)((int)centerX + resMin), 0.0f, (float)((int)centerX + 1), (float)height, 0.0f, 0.0f, 0.0f, progress, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        draw.drawTexColorRect(centerX, centerY, (float)resMin, (float)resMin, 1.0f, 1.0f, 1.0f, progress, 0.0f, 1.0f, 0.0f, 1.0f);
        draw.finish();
    }
}

