/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.gui.tooltip;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import pl.pabilo8.immersiveintelligence.api.rotary.CapabilityRotaryEnergy;
import pl.pabilo8.immersiveintelligence.api.rotary.IRotaryEnergy;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.gui.tooltip.TextOverlayBase;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;

public class TextOverlayMechanical
extends TextOverlayBase {
    @Override
    @ParametersAreNonnullByDefault
    public boolean shouldDraw(EntityPlayer player, RayTraceResult mouseOver, @Nullable TileEntity te, @Nullable Entity entityHit) {
        if (mouseOver.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        return te != null && te.hasCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, mouseOver.field_178784_b.func_176734_d()) && IIUtils.isTachometer(player.func_184586_b(EnumHand.MAIN_HAND));
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nullable
    public String[] getText(EntityPlayer player, RayTraceResult mouseOver, @Nullable TileEntity te, @Nullable Entity entityHit) {
        assert (te != null);
        IRotaryEnergy energy = (IRotaryEnergy)te.getCapability(CapabilityRotaryEnergy.ROTARY_ENERGY, mouseOver.field_178784_b.func_176734_d());
        assert (energy != null);
        float intTorque = energy.getTorque();
        float extTorque = energy.getOutputTorque();
        float intSpeed = energy.getRotationSpeed();
        float extSpeed = energy.getOutputRotationSpeed();
        if (intTorque != extTorque && intSpeed != extSpeed) {
            return new String[]{IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[0], "\u2296 " + I18n.func_135052_a((String)"info.immersiveintelligence.tachometer.internal_torque", (Object[])new Object[]{Float.valueOf(intTorque)})), IIUtils.getHexCol(IIReference.COLORS_HIGHLIGHT_S[0], "\u29c1 " + I18n.func_135052_a((String)"info.immersiveintelligence.tachometer.internal_speed", (Object[])new Object[]{Float.valueOf(intSpeed)})), "\u2296 " + I18n.func_135052_a((String)"info.immersiveintelligence.tachometer.external_torque", (Object[])new Object[]{Float.valueOf(extTorque)}), "\u29c1 " + I18n.func_135052_a((String)"info.immersiveintelligence.tachometer.external_speed", (Object[])new Object[]{Float.valueOf(extSpeed)})};
        }
        return new String[]{"\u2296 " + I18n.func_135052_a((String)"info.immersiveintelligence.tachometer.torque", (Object[])new Object[]{Float.valueOf(intTorque)}), "\u29c1 " + I18n.func_135052_a((String)"info.immersiveintelligence.tachometer.speed", (Object[])new Object[]{Float.valueOf(intSpeed)})};
    }

    @Override
    public int getDefaultFontColour() {
        return IIReference.COLORS_HIGHLIGHT_I[1];
    }

    @Override
    @Nonnull
    public FontRenderer getFontRenderer() {
        return IIClientUtils.fontRegular;
    }
}

