/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.manual.IEManualInstance;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualEntry;
import pl.pabilo8.immersiveintelligence.client.manual.pages.IIManualPageFolder;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public abstract class IIManualCategory {
    public abstract String getCategory();

    public void addPages() {
        IEManualInstance manual = (IEManualInstance)ManualHelper.getManual();
        manual.manualContents.removeAll((Object)this.getCategory());
        ((LinkedHashSet)ReflectionHelper.getPrivateValue(IEManualInstance.class, (Object)manual, (String[])new String[]{"categorySet"})).add(this.getCategory());
    }

    public static void cleanFolderEntries() {
        IEManualInstance manual = (IEManualInstance)ManualHelper.getManual();
        List remaining = manual.manualContents.get((Object)ManualHelper.CAT_UPDATE);
        remaining.removeIf(entry -> entry.getPages().length != 1 || !(entry.getPages()[0] instanceof IIManualPageFolder));
        for (ManualInstance.ManualEntry folder : remaining) {
            manual.manualContents.remove((Object)ManualHelper.CAT_UPDATE, (Object)folder);
        }
    }

    protected final IIManualEntry addEntry(String name) {
        IIManualPageFolder folder = this.createSubFolder(name, null);
        IIManualEntry entry = new IIManualEntry(name, this.getCategory());
        if (folder == null) {
            ManualHelper.getManual().manualContents.put((Object)this.getCategory(), (Object)entry);
        } else {
            folder.addEntry(entry);
        }
        return entry;
    }

    @Nullable
    private IIManualPageFolder createSubFolder(String fileName, @Nullable IIManualPageFolder folder) {
        if (!fileName.contains("/")) {
            return folder;
        }
        int i = fileName.indexOf("/");
        String folderName = fileName.substring(0, i);
        String remaining = fileName.substring(i + 1);
        if (folder == null) {
            List entries = ManualHelper.getManual().manualContents.get((Object)folderName);
            if (!entries.isEmpty()) {
                IManualPage[] pages = ((ManualInstance.ManualEntry)entries.get(0)).getPages();
                if (pages.length > 0 && pages[0] instanceof IIManualPageFolder) {
                    folder = (IIManualPageFolder)pages[0];
                }
            } else {
                folder = new IIManualPageFolder(ManualHelper.getManual(), folderName, this.getCategory());
            }
            return this.createSubFolder(remaining, folder);
        }
        return this.createSubFolder(remaining, folder.getOrCreateSubFolder(folderName));
    }

    protected final EasyNBT getSourceForItem(ItemStack stack) {
        return EasyNBT.newNBT().withItemStack("item", stack);
    }

    protected final EasyNBT getSourceForItems(ItemStack ... stacks) {
        return EasyNBT.newNBT().withList("items", stacks);
    }
}

