/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.IILogger;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualEntry
extends ManualInstance.ManualEntry {
    private final LinkedHashMap<String, String> texts = new LinkedHashMap();
    private final LinkedHashMap<String, EasyNBT> dataSources = new LinkedHashMap();
    private final String fullFilePath;

    public IIManualEntry(String name, String category) {
        super(name.contains("/") ? name.substring(name.lastIndexOf("/") + 1) : name, category, new IManualPage[0]);
        this.fullFilePath = name;
        this.loadTexts(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void loadTexts(boolean updateMeta) {
        Language lang = ClientUtils.mc().func_135016_M().func_135041_c();
        boolean nonEnglish = !lang.func_135034_a().equalsIgnoreCase("en_us");
        IResource stateFile = this.tryGetFile(lang.func_135034_a().toLowerCase());
        if (nonEnglish && stateFile == null) {
            stateFile = this.tryGetFile("en_us");
        }
        if (stateFile != null) {
            this.texts.clear();
            InputStream inputStream = stateFile.func_110527_b();
            String[] sections = new BufferedReader(new InputStreamReader(inputStream)).lines().map(s -> s.startsWith("#") ? s.replaceFirst("#", "\t") : s).collect(Collectors.joining("\n")).split("\t");
            IOUtils.closeQuietly((InputStream)inputStream);
            System.arraycopy(sections, 1, sections, 0, sections.length - 1);
            for (String s2 : sections) {
                String[] lines = s2.trim().split("\n");
                if (lines.length == 0) continue;
                lines[0] = lines[0].trim();
                if (lines[0].startsWith("meta")) {
                    if (!updateMeta || lines.length <= 1) continue;
                    Locale locale = I18n.field_135054_a;
                    if (I18n.field_135054_a == null) continue;
                    locale.field_135032_a.put("ie.manual.entry." + this.getName() + ".name", lines[1]);
                    if (lines.length <= 2) continue;
                    locale.field_135032_a.put("ie.manual.entry." + this.getName() + ".subtext", lines[2]);
                    continue;
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < lines.length; ++i) {
                    builder.append(lines[i].replace("%SECTION%", lines[0]).replace("%PAGE%", this.getName())).append("\n");
                }
                this.texts.put(lines[0], builder.toString());
            }
        } else {
            IILogger.error("Could not load manual page for %s", this.getName());
        }
        if (updateMeta) {
            this.setPages((IManualPage[])this.texts.keySet().stream().map(IIManualPage::new).peek(IIManualPage::setManual).peek(p -> p.setParent(this)).toArray(IIManualPage[]::new));
        }
    }

    @Nullable
    private IResource tryGetFile(String language) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("immersiveintelligence", String.format("ie_manual/%s/%s/%s.md", language, this.getCategory(), this.fullFilePath)));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IIManualEntry addSource(String name, EasyNBT source) {
        this.dataSources.put(name, source);
        return this;
    }

    @Nullable
    public EasyNBT getSource(String name) {
        return this.dataSources.getOrDefault(name, null);
    }

    public String fetchPage(String text) {
        this.loadTexts(false);
        return this.texts.getOrDefault(text, null);
    }

    public int getSubPageID(String name) {
        int i = 0;
        for (String s : this.texts.keySet()) {
            if (name.equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

