/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.api.utils.IAdvancedMultiblock;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.IIContent;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;
import pl.pabilo8.immersiveintelligence.common.util.multiblock.MultiblockStuctureBase;

public abstract class IIManualObject
extends GuiButtonManual {
    @Nonnull
    protected EasyNBT dataSource;
    @Nonnull
    protected final ManualInstance manual;

    public IIManualObject(ManualObjectInfo info, EasyNBT nbt) {
        super(info.gui, info.id, info.x, info.y, 0, 0, "");
        this.dataSource = nbt;
        this.manual = this.gui.getManual();
        nbt.checkSetInt("x", i -> {
            this.field_146128_h = info.x + i;
        });
        nbt.checkSetInt("w", i -> {
            this.field_146120_f = i;
        }, this.getDefaultWidth());
        nbt.checkSetInt("h", i -> {
            this.field_146121_g = i;
        }, this.getDefaultHeight());
    }

    public void postInit(IIManualPage page) {
        this.dataSource.checkSetString("source", s -> this.dataSource.mergeWith(page.getDataSource((String)s)));
    }

    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = mx >= this.field_146128_h && mx < this.field_146128_h + this.field_146120_f && my >= this.field_146129_i && my < this.field_146129_i + this.field_146121_g;
            this.func_146119_b(mc, mx, my);
        }
    }

    protected abstract int getDefaultHeight();

    protected int getDefaultWidth() {
        return 120;
    }

    protected final void func_146119_b(@Nonnull Minecraft mc, int mouseX, int mouseY) {
    }

    public abstract void mouseDragged(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @Nullable
    public abstract List<String> getTooltip(Minecraft var1, int var2, int var3);

    public String getText(EasyNBT nbt) {
        if (nbt.hasKey("text")) {
            return I18n.func_135052_a((String)nbt.getString("text"), (Object[])new Object[0]);
        }
        if (nbt.hasKey("item")) {
            return nbt.getItemStack("item").func_82833_r();
        }
        if (nbt.hasKey("mb")) {
            String mbName = nbt.getString("mb");
            MultiblockHandler.IMultiblock multiblock = MultiblockHandler.getMultiblocks().stream().filter(mb -> mb.getUniqueName().equals(mbName)).findFirst().orElse(null);
            if (multiblock instanceof MultiblockStuctureBase) {
                Vec3i offset = ((MultiblockStuctureBase)multiblock).getOffset();
                int[] size = ((MultiblockStuctureBase)multiblock).getSize();
                ItemStack hammerStack = multiblock.getClass().isAnnotationPresent(IAdvancedMultiblock.class) ? IIContent.itemHammer.getStack(1) : new ItemStack((Item)IEContent.itemTool, 1);
                ItemStack material = multiblock.getStructureManual()[offset.func_177956_o()][offset.func_177952_p()][offset.func_177958_n()];
                int materialRequired = 2;
                for (IngredientStack totalMaterial : multiblock.getTotalMaterials()) {
                    if (!totalMaterial.matchesItemStackIgnoringSize(material)) continue;
                    materialRequired = totalMaterial.inputSize;
                }
                StringBuilder position = new StringBuilder();
                return TextFormatting.DARK_GRAY + I18n.func_135052_a((String)(nbt.hasKey("long") ? "ie.manual.entry.multiblock_forming" : "ie.manual.entry.multiblock_forming_short"), (Object[])new Object[]{TextFormatting.BOLD + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + mbName), (Object[])new Object[0]) + TextFormatting.DARK_GRAY, TextFormatting.GOLD + hammerStack.func_82833_r() + TextFormatting.DARK_GRAY, position.toString(), TextFormatting.BOLD + material.func_82833_r() + TextFormatting.DARK_GRAY});
            }
            return "";
        }
        if (nbt.hasKey("fluid")) {
            return nbt.getFluidStack("fluid").getLocalizedName();
        }
        return "missingno";
    }

    private String getPositionKeyword(float offset, String left, String middle, String right, boolean allowNone) {
        if ((double)offset < 0.33) {
            return I18n.func_135052_a((String)("ie.manual.entry.multiblock_forming." + left), (Object[])new Object[0]);
        }
        if ((double)offset > 0.66) {
            return I18n.func_135052_a((String)("ie.manual.entry.multiblock_forming." + right), (Object[])new Object[0]);
        }
        if (allowNone && ((double)offset < 0.45 || (double)offset > 0.55)) {
            return "";
        }
        return middle.isEmpty() ? "" : I18n.func_135052_a((String)("ie.manual.entry.multiblock_forming." + middle), (Object[])new Object[0]);
    }

    public static class ManualObjectInfo {
        final GuiManual gui;
        final int x;
        final int y;
        final int id;

        public ManualObjectInfo(GuiManual gui, int x, int y, int id) {
            this.gui = gui;
            this.x = x;
            this.y = y;
            this.id = id;
        }
    }
}

