/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManual;
import blusunrize.lib.manual.gui.GuiButtonManualLink;
import blusunrize.lib.manual.gui.GuiManual;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualEntry;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManuaRegularText;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualBlueprint;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualCraftingRecipe;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualDataCallback;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualDataPacket;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualDataType;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualDataVariable;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualHorizontalLine;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualImage;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualItemDisplay;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualMultiblock;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualScenario;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualTable;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualText;
import pl.pabilo8.immersiveintelligence.client.manual.objects.IIManualUpgradeDisplay;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.ISerializableEnum;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualPage
extends ManualPages {
    private static final int WIDTH = 120;
    public static final HashMap<String, BiFunction<IIManualObject.ManualObjectInfo, EasyNBT, IIManualObject>> registeredObjects = new HashMap();
    static final Pattern patternObject = Pattern.compile("\\|(.+?)\\|");
    static final Pattern patternLink = Pattern.compile("\\[([^\\[]+)]\\((.*?)\\)");
    static final Pattern patternHighlight = Pattern.compile("\\[(.+?)]");
    static final Pattern patternBold = Pattern.compile("\\*\\*(.+?)\\*\\*");
    static final Pattern patternItalic = Pattern.compile("\\*(.+?)\\*");
    static final Pattern patternUnderline = Pattern.compile("__(.+?)__");
    static final Pattern patternStrikethrough = Pattern.compile("~~(.+?)~~");
    private final ArrayList<IIManualObject> manualObjects = new ArrayList();
    private final ArrayList<PageTraits> traits = new ArrayList();
    private IIManualEntry entry;
    private HoverTooltipWrapper tooltipWrapper;

    public IIManualPage(String name) {
        super(null, name);
    }

    public void setParent(IIManualEntry entry) {
        this.entry = entry;
    }

    public void setManual() {
        this.manual = ManualHelper.getManual();
    }

    @SideOnly(value=Side.CLIENT)
    public void initPage(GuiManual gui, int x, int y, List<GuiButton> pageButtons) {
        this.highlighted = ItemStack.field_190927_a;
        String file = this.entry.fetchPage(this.text);
        if (file != null && !file.isEmpty()) {
            file = this.addTraits(file);
            this.manualObjects.clear();
            this.addObjects(file, x, y, pageButtons, gui);
            this.tooltipWrapper = new HoverTooltipWrapper(gui);
            pageButtons.add((GuiButton)this.tooltipWrapper);
            this.localizedText = "";
            this.manual.fontRenderer.func_78264_a(this.manual.fontRenderer.func_82883_a());
        }
    }

    private String addTraits(String file) {
        this.traits.clear();
        if (!file.startsWith("@")) {
            return file;
        }
        int endIndex = file.indexOf("\n");
        for (String trait : file.substring(file.indexOf("@") + 1, endIndex).split(";")) {
            PageTraits found = PageTraits.find(trait.trim());
            if (found == null) continue;
            this.traits.add(found);
        }
        this.traits.sort(Comparator.comparingInt(Enum::ordinal));
        return file.substring(endIndex);
    }

    private String addLinks(String file) {
        return this.matchReplace(patternLink, file, (stringBuilder, matcher) -> {
            List manualEntries;
            String[] split;
            String link = matcher.group(2).replace(".md", "");
            String sub = "";
            if (link.startsWith("#")) {
                sub = ";" + this.entry.getSubPageID(link.substring(1));
                link = this.entry.getName();
            } else if (link.contains("#") && (split = link.split("#")).length > 1 && !(manualEntries = this.manual.manualContents.values().stream().filter(me -> me.getName().equals(split[0])).collect(Collectors.toList())).isEmpty()) {
                IManualPage[] pages = ((ManualInstance.ManualEntry)manualEntries.get(0)).getPages();
                link = split[0];
                for (int i = 0; i < pages.length; ++i) {
                    String pageName;
                    IManualPage page = pages[i];
                    if (!(page instanceof ManualPages) || !(pageName = (String)ReflectionHelper.getPrivateValue(ManualPages.class, (Object)((ManualPages)page), (String[])new String[]{"text"})).equals(split[1])) continue;
                    sub = ";" + i;
                    break;
                }
            }
            stringBuilder.append("<link;").append(link).append(";").append(Arrays.stream(matcher.group(1).split(" ")).map(s -> TextFormatting.ITALIC.toString() + TextFormatting.UNDERLINE + s).collect(Collectors.joining(" "))).append(TextFormatting.RESET).append(sub).append(">");
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPage(GuiManual gui, int x, int y, int mx, int my) {
        if (this.localizedText != null && !this.localizedText.isEmpty()) {
            ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)this.localizedText, (int)x, (int)y, (int)120, (int)this.manual.getTextColour());
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        ISerializableEnum hoveredTrait = null;
        int traitsSize = this.traits.size();
        for (int i = 0; i < traitsSize; ++i) {
            IIClientUtils.bindTexture(this.traits.get(i).textureLocation);
            Gui.func_146110_a((int)(x + 108), (int)(y + i * 18), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            if (hoveredTrait != null || !IIUtils.isPointInRectangle(x + 108, y + i * 18, x + 108 + 16, y + i * 18 + 16, mx, my)) continue;
            hoveredTrait = this.traits.get(i);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        for (IIManualObject object : this.manualObjects) {
            this.tooltipWrapper.tooltip = object.getTooltip(gui.field_146297_k, mx, my);
            if (this.tooltipWrapper.tooltip == null) continue;
            break;
        }
        if (this.tooltipWrapper.tooltip == null && hoveredTrait != null) {
            this.tooltipWrapper.tooltip = Collections.singletonList(I18n.func_135052_a((String)("ie.manual.entry.traits." + hoveredTrait.func_176610_l()), (Object[])new Object[0]));
        }
        GlStateManager.func_179121_F();
    }

    public void buttonPressed(GuiManual gui, GuiButton button) {
        super.buttonPressed(gui, button);
    }

    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        for (IIManualObject obj : this.manualObjects) {
            obj.mouseDragged(x, y, clickX, clickY, mx, my, lastX, lastY, button);
        }
    }

    public boolean listForSearch(String searchTag) {
        return false;
    }

    private String matchReplace(Pattern pattern, String text, BiConsumer<StringBuilder, Matcher> operation) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = pattern.matcher(text);
        int i = 0;
        while (matcher.find()) {
            builder.append(text, i, matcher.start());
            operation.accept(builder, matcher);
            i = matcher.end();
        }
        builder.append(text.substring(i));
        return builder.toString();
    }

    private String matchReplaceSimple(Pattern pattern, String text, TextFormatting ... formats) {
        return this.matchReplace(pattern, text, (stringBuilder, matcher) -> {
            for (TextFormatting format : formats) {
                stringBuilder.append(format);
            }
            stringBuilder.append(matcher.group(1)).append(TextFormatting.RESET);
        });
    }

    private String addObjects(String file, int x, int y, List<GuiButton> pageButtons, GuiManual gui) {
        StringBuilder builder = new StringBuilder();
        String[] split = file.split("\n");
        int[] yOffset = new int[]{0};
        int traitsOffset = this.traits.size() * 16;
        boolean flag = this.manual.fontRenderer.func_82883_a();
        this.manual.fontRenderer.func_78264_a(true);
        int splitLength = split.length;
        for (int i = 0; i < splitLength; ++i) {
            String line = split[i];
            if (line.isEmpty()) continue;
            if (line.startsWith("|") || i == splitLength - 1 || yOffset[0] < traitsOffset) {
                if (!line.startsWith("|")) {
                    builder.append(line).append("\n");
                }
                if (builder.length() > 0) {
                    String textParsed = builder.toString();
                    textParsed = this.addLinks(textParsed);
                    textParsed = this.matchReplaceSimple(patternHighlight, textParsed, TextFormatting.BOLD, TextFormatting.GOLD);
                    textParsed = this.matchReplaceSimple(patternBold, textParsed, TextFormatting.BOLD);
                    textParsed = this.matchReplaceSimple(patternItalic, textParsed, TextFormatting.ITALIC);
                    textParsed = this.matchReplaceSimple(patternUnderline, textParsed, TextFormatting.UNDERLINE);
                    textParsed = this.matchReplaceSimple(patternStrikethrough, textParsed, TextFormatting.STRIKETHROUGH);
                    IIManuaRegularText textObject = new IIManuaRegularText(this.getInfoForNext(gui, pageButtons, x, y + yOffset[0]), textParsed, pageButtons);
                    if (yOffset[0] < traitsOffset) {
                        textObject.field_146120_f -= 14;
                    }
                    textObject.postInit(this);
                    yOffset[0] = yOffset[0] + textObject.field_146121_g;
                    pageButtons.add((GuiButton)textObject);
                    builder.delete(0, builder.length());
                    textObject.field_146121_g = 0;
                }
                this.matchReplace(patternObject, line, (stringBuilder, matcher) -> {
                    String text = matcher.group(1);
                    IIManualObject object = this.parseObject(gui, pageButtons, text, x, y + yOffset[0]);
                    if (object != null) {
                        object.postInit(this);
                        yOffset[0] = yOffset[0] + object.field_146121_g;
                        this.manualObjects.add(object);
                        pageButtons.add((GuiButton)object);
                    }
                });
                continue;
            }
            builder.append(line).append("\n");
        }
        this.manual.fontRenderer.func_78264_a(flag);
        pageButtons.sort((o1, o2) -> o1 instanceof GuiButtonManualLink ? 1 : -1);
        return builder.toString();
    }

    @Nullable
    private IIManualObject parseObject(GuiManual gui, List<GuiButton> pageButtons, String text, int x, int y) {
        String objectTag;
        Matcher matcherName = Pattern.compile("\\[(.+?)]").matcher(text);
        Matcher matcherTag = Pattern.compile("\\{(.+?)}\\|").matcher(text + "|");
        String objectID = matcherName.find() ? matcherName.group(1) : "";
        String string = objectTag = matcherTag.find() ? String.format("{%s}", matcherTag.group(1)) : "";
        if (objectID.isEmpty()) {
            return null;
        }
        BiFunction fun = registeredObjects.getOrDefault(objectID, null);
        if (fun != null) {
            return (IIManualObject)((Object)fun.apply(this.getInfoForNext(gui, pageButtons, x, y), EasyNBT.parseEasyNBT(objectTag, new Object[0])));
        }
        return null;
    }

    private IIManualObject.ManualObjectInfo getInfoForNext(GuiManual gui, List<GuiButton> pageButtons, int x, int y) {
        return new IIManualObject.ManualObjectInfo(gui, x, y, pageButtons.size() + 100);
    }

    @Nullable
    public EasyNBT getDataSource(String name) {
        return this.entry.getSource(name);
    }

    static {
        registeredObjects.put("image", IIManualImage::new);
        registeredObjects.put("text", IIManualText::new);
        registeredObjects.put("table", IIManualTable::new);
        registeredObjects.put("scenario", IIManualScenario::new);
        registeredObjects.put("hr", IIManualHorizontalLine::new);
        registeredObjects.put("multiblock", IIManualMultiblock::new);
        registeredObjects.put("crafting", IIManualCraftingRecipe::new);
        registeredObjects.put("blueprint", IIManualBlueprint::new);
        registeredObjects.put("item_display", IIManualItemDisplay::new);
        registeredObjects.put("upgrade_display", IIManualUpgradeDisplay::new);
        registeredObjects.put("datatype", IIManualDataType::new);
        registeredObjects.put("data_packet", IIManualDataPacket::new);
        registeredObjects.put("data_variable", IIManualDataVariable::new);
        registeredObjects.put("data_callback", IIManualDataCallback::new);
    }

    private static enum PageTraits implements ISerializableEnum
    {
        LEVEL_BEGINNER,
        LEVEL_EARLY_INDUSTRIAL,
        LEVEL_INDUSTRIAL,
        LEVEL_ADVANCED_INDUSTRIAL,
        LEVEL_CIRCUITS,
        LEVEL_COMPUTER,
        HAMMER,
        HAMMER_ELECTRIC,
        UPGRADABLE,
        REPAIRABLE,
        DECORATIONS,
        PAINTABLE;

        private final ResLoc textureLocation = ResLoc.of(IIReference.RES_TEXTURES_MANUAL, "traits/", this.func_176610_l()).withExtension(".png");

        public static PageTraits find(String name) {
            return Arrays.stream(PageTraits.values()).filter(p -> p.func_176610_l().equals(name)).findFirst().orElse(null);
        }
    }

    private static class HoverTooltipWrapper
    extends GuiButtonManual {
        List<String> tooltip;

        public HoverTooltipWrapper(GuiManual gui) {
            super(gui, 999, -1, -1, 1, 1, "");
        }

        public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                ClientUtils.drawHoveringText(this.tooltip, (int)mx, (int)my, (FontRenderer)this.gui.getManual().fontRenderer, (int)this.gui.field_146294_l, (int)-1);
                RenderHelper.func_74520_c();
            }
        }
    }
}

