/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.lib.manual.ManualPages;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualCraftingRecipe
extends IIManualObject {
    GuiButtonManualNavigation buttonNext;
    GuiButtonManualNavigation buttonPrev;
    NonNullList<ItemStack> stacks;
    ItemStack highlighted = ItemStack.field_190927_a;
    final ArrayList<ManualPages.PositionedItemStack[]> recipes = new ArrayList();
    int recipePage;
    int yOff;

    public IIManualCraftingRecipe(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        this.stacks = NonNullList.func_191196_a();
        this.dataSource.checkSetCompound("item", nbt -> this.stacks.add((Object)new ItemStack(nbt)));
        if (this.dataSource.hasKey("items")) {
            this.dataSource.streamList(NBTTagCompound.class, "items", 10).map(ItemStack::new).forEach(arg_0 -> this.stacks.add(arg_0));
        }
        this.recalculateCraftingRecipes(page);
        if (this.recipes.size() > 1) {
            this.buttonPrev = new GuiButtonManualNavigation(this.gui, 100, this.field_146128_h - 2, this.field_146129_i + this.yOff / 2 - 3, 8, 10, 0);
            this.buttonNext = new GuiButtonManualNavigation(this.gui, 101, this.field_146128_h + 122 - 16, this.field_146129_i + this.yOff / 2 - 3, 8, 10, 1);
        }
        this.field_146121_g = this.yOff;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        this.highlighted = ItemStack.field_190927_a;
        GlStateManager.func_179094_E();
        if (this.recipes.size() > 1) {
            this.buttonNext.func_191745_a(mc, mx, my, partialTicks);
            this.buttonPrev.func_191745_a(mc, mx, my, partialTicks);
        }
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            int maxX = 0;
            ManualPages.PositionedItemStack[] positionedItemStackArray = this.recipes.get(this.recipePage);
            int n = positionedItemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ManualPages.PositionedItemStack pstack = positionedItemStackArray[i];
                if (pstack == null) continue;
                if (pstack.x > maxX) {
                    maxX = pstack.x;
                }
                this.gui.func_73733_a(this.field_146128_h + pstack.x, this.field_146129_i + pstack.y, this.field_146128_h + pstack.x + 16, this.field_146129_i + pstack.y + 16, 0x33666666, 0x33666666);
            }
            ManualUtils.bindTexture((String)this.manual.texture);
            ManualUtils.drawTexturedRect((int)(this.field_146128_h + maxX - 17), (int)(this.field_146129_i + this.yOff / 2 - 5), (int)16, (int)10, (double[])new double[]{0.0, 0.0625, 0.8828125, 0.921875});
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        RenderHelper.func_74520_c();
        this.manual.fontRenderer.func_78264_a(false);
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            for (ManualPages.PositionedItemStack pstack : this.recipes.get(this.recipePage)) {
                if (pstack == null || pstack.getStack().func_190926_b()) continue;
                ManualUtils.renderItem().func_180450_b(pstack.getStack(), this.field_146128_h + pstack.x, this.field_146129_i + pstack.y);
                ManualUtils.renderItem().func_180453_a(this.manual.fontRenderer, pstack.getStack(), this.field_146128_h + pstack.x, this.field_146129_i + pstack.y, null);
                if (mx < this.field_146128_h + pstack.x || mx >= this.field_146128_h + pstack.x + 16 || my < this.field_146129_i + pstack.y || my >= this.field_146129_i + pstack.y + 16) continue;
                this.highlighted = pstack.getStack();
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        GlStateManager.func_179101_C();
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    @Override
    protected int getDefaultHeight() {
        return 20;
    }

    public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.recipes.size() > 1 && super.func_146116_c(mc, mouseX, mouseY)) {
            if (this.buttonPrev.func_146116_c(mc, mouseX, mouseY)) {
                if (this.recipePage > 0) {
                    --this.recipePage;
                }
            } else if (this.buttonNext.func_146116_c(mc, mouseX, mouseY)) {
                if (this.recipePage < this.recipes.size() - 1) {
                    ++this.recipePage;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        return !this.highlighted.func_190926_b() ? this.gui.func_191927_a(this.highlighted) : null;
    }

    private void recalculateCraftingRecipes(IIManualPage page) {
        this.recipes.clear();
        HashSet searchCrafting = new HashSet();
        IntStream.range(0, this.stacks.size()).forEachOrdered(i -> {
            searchCrafting.add(i);
            page.addProvidedItem((ItemStack)this.stacks.get(i));
        });
        if (!searchCrafting.isEmpty()) {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                Iterator iterator = searchCrafting.iterator();
                while (iterator.hasNext()) {
                    int iStack = (Integer)iterator.next();
                    if (recipe.func_77571_b().func_190926_b() || !ManualUtils.stackMatchesObject((ItemStack)recipe.func_77571_b(), (Object)this.stacks.get(iStack))) continue;
                    this.handleRecipe(recipe, iStack);
                }
            }
        }
    }

    private void handleRecipe(IRecipe recipe, int iStack) {
        int h;
        int w;
        NonNullList ingredientsPre = recipe.func_192400_c();
        if (recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe) {
            int n = ingredientsPre.size() > 6 ? 3 : (w = ingredientsPre.size() > 1 ? 2 : 1);
            h = ingredientsPre.size() > 4 ? 3 : (ingredientsPre.size() > 2 ? 2 : 1);
        } else if (recipe instanceof IShapedRecipe) {
            w = ((IShapedRecipe)recipe).getRecipeWidth();
            h = ((IShapedRecipe)recipe).getRecipeHeight();
        } else {
            return;
        }
        ManualPages.PositionedItemStack[] pIngredients = new ManualPages.PositionedItemStack[ingredientsPre.size() + 1];
        int xBase = (120 - (w + 2) * 18) / 2;
        for (int hh = 0; hh < h; ++hh) {
            for (int ww = 0; ww < w; ++ww) {
                if (hh * w + ww >= ingredientsPre.size()) continue;
                pIngredients[hh * w + ww] = new ManualPages.PositionedItemStack(ingredientsPre.get(hh * w + ww), xBase + ww * 18, hh * 18);
            }
        }
        pIngredients[pIngredients.length - 1] = new ManualPages.PositionedItemStack((Object)recipe.func_77571_b(), xBase + w * 18 + 18, (int)((float)h / 2.0f * 18.0f) - 8);
        if (iStack < this.recipes.size()) {
            this.recipes.add(iStack, pIngredients);
        } else {
            this.recipes.add(pIngredients);
        }
        if (h * 18 > this.yOff) {
            this.yOff = h * 18;
        }
    }
}

