/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualDataCallback
extends IIManualObject {
    private static final ResLoc TEXTURE_CALLBACK = ResLoc.of(IIReference.RES_TEXTURES_MANUAL, "data/callback").withExtension(".png");
    @Nonnull
    IDataType type = new DataTypeNull();
    String name;
    String label;
    String returns;

    public IIManualDataCallback(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        Class<DataTypeNull> clazz = DataPacket.varTypes.getOrDefault(this.dataSource.getString("type"), DataTypeNull.class);
        this.type = DataPacket.getVarInstance(clazz);
        this.dataSource.checkSetString("name", s -> {
            this.name = s;
        }, "missingno");
        this.dataSource.checkSetString("label", s -> {
            this.label = s;
        }, this.name);
        this.dataSource.checkSetString("returns", s -> {
            this.returns = s;
        }, "void");
    }

    @Override
    protected int getDefaultHeight() {
        return 16;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        GlStateManager.func_179094_E();
        ClientUtils.bindTexture((String)this.type.textureLocation());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        IIClientUtils.bindTexture(TEXTURE_CALLBACK);
        Gui.func_146110_a((int)(this.field_146128_h - 1), (int)(this.field_146129_i - 1), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        GlStateManager.func_179121_F();
        boolean unicodeFlag = this.manual.fontRenderer.func_82883_a();
        this.manual.fontRenderer.func_78264_a(true);
        this.func_73731_b(this.manual.fontRenderer, this.name, this.field_146128_h + 18, this.field_146129_i + 2, this.manual.getTextColour());
        this.manual.fontRenderer.func_78264_a(unicodeFlag);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return super.func_146116_c(mc, mouseX, mouseY);
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        if (this.field_146123_n) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(String.format("<%s> %s", IIUtils.getHexCol(this.type.getTypeColour(), I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + this.type.getName()), (Object[])new Object[0])), IIUtils.getItalicString(this.name)));
            lines.add(TextFormatting.GRAY + this.label);
            lines.add(I18n.func_135052_a((String)"ie.manual.entry.callback_returns", (Object[])new Object[0]) + " " + TextFormatting.GRAY + IIUtils.getItalicString(this.returns));
            return lines;
        }
        return null;
    }
}

