/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.types.DataTypeNull;
import pl.pabilo8.immersiveintelligence.api.data.types.IDataType;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.gui.IDataMachineGui;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.client.util.ResLoc;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.IIReference;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualDataVariable
extends IIManualObject {
    private static final ResLoc TEXTURE_IN = ResLoc.of(IIReference.RES_TEXTURES_MANUAL, "data/input").withExtension(".png");
    private static final ResLoc TEXTURE_OUT = ResLoc.of(IIReference.RES_TEXTURES_MANUAL, "data/output").withExtension(".png");
    @Nonnull
    IDataType type = new DataTypeNull();
    String letter;
    String name;
    String description;
    String value;
    HashMap<String, String> values;
    HashMap<Character, String> requirements;
    boolean inputVariable;

    public IIManualDataVariable(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        Class<DataTypeNull> clazz = DataPacket.varTypes.getOrDefault(this.dataSource.getString("type"), DataTypeNull.class);
        this.type = DataPacket.getVarInstance(clazz);
        this.dataSource.checkSetString("letter", s -> {
            this.letter = s;
        }, "");
        this.dataSource.checkSetString("name", s -> {
            this.name = s;
        }, "");
        this.dataSource.checkSetString("description", s -> {
            this.description = s;
        }, "");
        this.dataSource.checkSetString("direction", b -> {
            this.inputVariable = b.equals("out");
        }, "in");
        this.value = null;
        this.values = null;
        if (this.dataSource.hasKey("values")) {
            this.values = new HashMap();
            this.values.putAll(this.dataSource.streamList(NBTTagList.class, "values").collect(Collectors.toMap(nbt -> ((NBTTagString)nbt.func_179238_g(0)).func_150285_a_(), nbt -> ((NBTTagString)nbt.func_179238_g(1)).func_150285_a_())));
        } else {
            this.dataSource.checkSetString("value", v -> {
                this.value = v;
            });
        }
        if (this.dataSource.hasKey("requirements")) {
            this.requirements = new HashMap();
            EasyNBT nbt2 = this.dataSource.getEasyCompound("requirements");
            for (char c : DataPacket.varCharacters) {
                nbt2.checkSetString(String.valueOf(c), tag -> this.requirements.put(Character.valueOf(c), (String)tag));
            }
        } else {
            this.requirements = null;
        }
        boolean unicodeFlag = this.manual.fontRenderer.func_82883_a();
        this.manual.fontRenderer.func_78264_a(true);
        this.field_146121_g += Math.max(0, this.manual.fontRenderer.func_78267_b(this.description, this.field_146120_f) + 8 - this.field_146121_g);
        this.manual.fontRenderer.func_78264_a(unicodeFlag);
    }

    @Override
    protected int getDefaultHeight() {
        return 16;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        GlStateManager.func_179094_E();
        ClientUtils.bindTexture((String)this.type.textureLocation());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        Gui.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        IIClientUtils.bindTexture(this.inputVariable ? TEXTURE_IN : TEXTURE_OUT);
        Gui.func_146110_a((int)(this.field_146128_h - 3), (int)this.field_146129_i, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        GlStateManager.func_179121_F();
        boolean unicodeFlag = this.manual.fontRenderer.func_82883_a();
        this.manual.fontRenderer.func_78264_a(true);
        if (this.letter != null) {
            this.manual.fontRenderer.func_78276_b(TextFormatting.BOLD + this.letter, this.field_146128_h + 18, this.field_146129_i + 4, this.type.getTypeColour());
        }
        this.manual.fontRenderer.func_78276_b(TextFormatting.BOLD + this.name, this.field_146128_h + (this.letter == null ? 18 : 24), this.field_146129_i - 4, this.manual.getTextColour());
        this.manual.fontRenderer.func_78279_b(this.description, this.field_146128_h + (this.letter == null ? 18 : 24), this.field_146129_i + 4, this.letter == null ? 110 : 104, this.manual.getTextColour());
        this.manual.fontRenderer.func_78264_a(unicodeFlag);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean b = super.func_146116_c(mc, mouseX, mouseY);
        if (b && this.letter != null && Minecraft.func_71410_x().field_71462_r instanceof IDataMachineGui) {
            ((IDataMachineGui)Minecraft.func_71410_x().field_71462_r).editVariable(this.letter.charAt(0), (IDataType)new DataPacket().getVarInType(this.type.getClass(), new DataTypeNull()));
        }
        return b;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        if (this.field_146123_n) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(String.format("<%s> %s", IIUtils.getHexCol(this.type.getTypeColour(), I18n.func_135052_a((String)("datasystem.immersiveintelligence.datatype." + this.type.getName()), (Object[])new Object[0])), this.name));
            lines.addAll(this.manual.fontRenderer.func_78271_c(TextFormatting.GRAY + IIUtils.getItalicString(this.description), 140));
            if (this.values != null) {
                lines.add("");
                lines.add(I18n.func_135052_a((String)"ie.manual.entry.allowed_values", (Object[])new Object[0]));
                this.values.forEach((key, value) -> lines.addAll(this.manual.fontRenderer.func_78271_c(TextFormatting.BOLD + " > " + key + TextFormatting.RESET + TextFormatting.GRAY + " - " + value, 160)));
            } else if (this.value != null) {
                lines.add(I18n.func_135052_a((String)"ie.manual.entry.allowed_value", (Object[])new Object[0]) + " " + TextFormatting.GRAY + this.value);
            }
            if (this.requirements != null) {
                lines.add("");
                lines.add(I18n.func_135052_a((String)"ie.manual.entry.required_variables", (Object[])new Object[0]));
                this.requirements.forEach((key, value) -> lines.addAll(this.manual.fontRenderer.func_78271_c(TextFormatting.BOLD + " > " + key + TextFormatting.RESET + " = [" + TextFormatting.GRAY + value + TextFormatting.RESET + "]", 160)));
            }
            return lines;
        }
        return null;
    }
}

