/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.lib.manual.ManualUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualItemDisplay
extends IIManualObject {
    NonNullList<ItemStack> stacks;
    ItemStack highlighted = ItemStack.field_190927_a;

    public IIManualItemDisplay(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        this.stacks = NonNullList.func_191196_a();
        this.dataSource.checkSetCompound("item", nbt -> this.stacks.add((Object)new ItemStack(nbt)));
        if (this.dataSource.hasKey("items")) {
            this.dataSource.streamList(NBTTagCompound.class, "items", 10).map(ItemStack::new).forEach(arg_0 -> this.stacks.add(arg_0));
        }
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        this.highlighted = ItemStack.field_190927_a;
        int length = this.stacks.size();
        if (length > 0) {
            float scale = length > 8 ? 1.0f : (length > 3 ? 1.5f : 2.0f);
            int line0 = (int)(7.5 / (double)scale);
            int line1 = line0 - 1;
            int lineSum = line0 + line1;
            int lines = length / lineSum * 2 + length % lineSum / line0 + (length % lineSum % line0 > 0 ? 1 : 0);
            float equalPerLine = (float)length / (float)lines;
            line1 = (int)Math.floor(equalPerLine);
            line0 = (int)Math.ceil(equalPerLine);
            lineSum = line0 + line1;
            int lastLines = length % lineSum;
            int lastLine = lastLines == line0 ? line0 : (lastLines == 0 ? line1 : lastLines % line0);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            for (int line = 0; line < lines; ++line) {
                int item;
                int perLine;
                int n = line == lines - 1 ? lastLine : (perLine = line % 2 == 0 ? line0 : line1);
                if (line == 0 && perLine > length) {
                    perLine = length;
                }
                int w2 = perLine * (int)(18.0f * scale) / 2;
                for (int i = 0; i < perLine && (item = line / 2 * lineSum + line % 2 * line0 + i) < length; ++i) {
                    int xx = this.field_146128_h + 60 - w2 + (int)((float)(i * 18) * scale);
                    int yy = this.field_146129_i + (lines < 2 ? 4 : 0) + line * (int)(18.0f * scale);
                    ManualUtils.renderItem().func_180450_b((ItemStack)this.stacks.get(item), (int)((float)xx / scale), (int)((float)yy / scale));
                    if (mx < xx || !((float)mx < (float)xx + 16.0f * scale) || my < yy || !((float)my < (float)yy + 16.0f * scale)) continue;
                    this.highlighted = (ItemStack)this.stacks.get(item);
                }
            }
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
    }

    @Override
    protected int getDefaultHeight() {
        return 33;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        if (!this.highlighted.func_190926_b()) {
            return this.gui.func_191927_a(this.highlighted);
        }
        return null;
    }
}

