/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import org.lwjgl.opengl.GL11;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualMultiblock
extends IIManualObject {
    private MultiblockHandler.IMultiblock multiblock;
    private boolean canTick = true;
    private boolean showCompleted = false;
    private int tick = 0;
    private float scale = 50.0f;
    private float transX = 0.0f;
    private float transY = 0.0f;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private int half;
    GuiButtonManualNavigation buttonStop;
    GuiButtonManualNavigation buttonPause;
    GuiButtonManualNavigation buttonUp;
    GuiButtonManualNavigation buttonDown;
    List<String> componentTooltip;
    MultiblockRenderInfo renderInfo;
    MultiblockBlockAccess blockAccess;

    public IIManualMultiblock(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        IngredientStack[] totalMaterials;
        super.postInit(page);
        String mbName = this.dataSource.getString("mb");
        this.multiblock = MultiblockHandler.getMultiblocks().stream().filter(mb -> mb.getUniqueName().equals(mbName)).findFirst().orElse(null);
        if (this.multiblock != null && this.multiblock.getStructureManual() != null) {
            this.renderInfo = new MultiblockRenderInfo(this.multiblock);
            this.blockAccess = new MultiblockBlockAccess(this.renderInfo);
            this.transX = (float)(this.field_146128_h + 60) + (float)this.renderInfo.structureWidth / 2.0f;
            this.transY = (float)(this.field_146129_i + 35) + (float)Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0f;
            this.rotX = 25.0f;
            this.rotY = -45.0f;
            this.scale = this.multiblock.getManualScale();
            boolean canRenderFormed = this.multiblock.canRenderFormedStructure();
            this.buttonPause = new GuiButtonManualNavigation(this.gui, 100, this.field_146128_h + 4, (int)this.transY - (canRenderFormed ? 11 : 5), 10, 10, 4);
            if (canRenderFormed) {
                this.buttonStop = new GuiButtonManualNavigation(this.gui, 103, this.field_146128_h + 4, (int)this.transY + 1, 10, 10, 6);
            }
            if (this.renderInfo.structureHeight > 1) {
                this.buttonUp = new GuiButtonManualNavigation(this.gui, 101, this.field_146128_h + 4, (int)this.transY - (canRenderFormed ? 14 : 8) - 16, 10, 16, 3);
                this.buttonDown = new GuiButtonManualNavigation(this.gui, 102, this.field_146128_h + 4, (int)this.transY + (canRenderFormed ? 14 : 8), 10, 16, 2);
            }
        }
        if (this.multiblock != null && (totalMaterials = this.multiblock.getTotalMaterials()) != null) {
            IngredientStack req;
            int ss;
            this.componentTooltip = new ArrayList<String>();
            this.componentTooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.reqMaterial", (Object[])new Object[0]));
            int maxOff = 1;
            boolean hasAnyItems = false;
            boolean[] hasItems = new boolean[totalMaterials.length];
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                ItemStack inSlot;
                if (totalMaterials[ss] == null) continue;
                req = totalMaterials[ss];
                int reqSize = req.inputSize;
                for (int slot = 0; slot < ManualUtils.mc().field_71439_g.field_71071_by.func_70302_i_() && ((inSlot = ManualUtils.mc().field_71439_g.field_71071_by.func_70301_a(slot)).func_190926_b() || !req.matchesItemStackIgnoringSize(inSlot) || (reqSize -= inSlot.func_190916_E()) > 0); ++slot) {
                }
                if (reqSize <= 0) {
                    hasItems[ss] = true;
                    if (!hasAnyItems) {
                        hasAnyItems = true;
                    }
                }
                maxOff = Math.max(maxOff, ("" + req.inputSize).length());
            }
            for (ss = 0; ss < totalMaterials.length; ++ss) {
                if (totalMaterials[ss] == null) continue;
                req = totalMaterials[ss];
                int indent = maxOff - ("" + req.inputSize).length();
                StringBuilder sIndent = new StringBuilder();
                if (indent > 0) {
                    for (int ii = 0; ii < indent; ++ii) {
                        sIndent.append("0");
                    }
                }
                String s = hasItems[ss] ? TextFormatting.GREEN + TextFormatting.BOLD.toString() + "\u2713" + TextFormatting.RESET + " " : (hasAnyItems ? "   " : "");
                s = s + TextFormatting.GRAY + sIndent.toString() + req.inputSize + "x " + TextFormatting.RESET;
                ItemStack example = req.getExampleStack();
                s = !example.func_190926_b() ? s + example.func_77953_t().field_77937_e + example.func_82833_r() : s + "???";
                this.componentTooltip.add(s);
            }
        }
        int yOffTotal = (int)((double)(this.transY - (float)this.field_146129_i) + (double)this.scale * Math.sqrt(this.renderInfo.structureHeight * this.renderInfo.structureHeight + this.renderInfo.structureWidth * this.renderInfo.structureWidth + this.renderInfo.structureLength * this.renderInfo.structureLength) / 2.0);
        this.half = yOffTotal >> 1;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        this.buttonStop.func_191745_a(mc, mx, my, partialTicks);
        this.buttonPause.func_191745_a(mc, mx, my, partialTicks);
        if (this.renderInfo.structureHeight > 1) {
            this.buttonUp.func_191745_a(mc, mx, my, partialTicks);
            this.buttonDown.func_191745_a(mc, mx, my, partialTicks);
        }
        this.manual.fontRenderer.func_175065_a("?", (float)(this.field_146128_h + 116), (float)(this.field_146129_i + this.half - 4), this.manual.getTextColour(), false);
        int stackDepth = GL11.glGetInteger((int)2979);
        try {
            if (this.multiblock.getStructureManual() != null) {
                if (this.canTick && ++this.tick % 20 == 0) {
                    this.renderInfo.step();
                }
                int structureLength = this.renderInfo.structureLength;
                int structureWidth = this.renderInfo.structureWidth;
                int structureHeight = this.renderInfo.structureHeight;
                GlStateManager.func_179091_B();
                GlStateManager.func_179094_E();
                RenderHelper.func_74518_a();
                BlockRendererDispatcher blockRender = Minecraft.func_71410_x().func_175602_ab();
                GlStateManager.func_179109_b((float)this.transX, (float)this.transY, (float)Math.max(structureHeight, Math.max(structureWidth, structureLength)));
                GlStateManager.func_179152_a((float)this.scale, (float)(-this.scale), (float)1.0f);
                GlStateManager.func_179114_b((float)this.rotX, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(90.0f + this.rotY), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)((float)structureLength / -2.0f), (float)((float)structureHeight / -2.0f), (float)((float)structureWidth / -2.0f));
                GlStateManager.func_179140_f();
                if (Minecraft.func_71379_u()) {
                    GlStateManager.func_179103_j((int)7425);
                } else {
                    GlStateManager.func_179103_j((int)7424);
                }
                this.gui.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                int idx = 0;
                if (this.showCompleted && this.multiblock.canRenderFormedStructure()) {
                    this.multiblock.renderFormedStructure();
                } else {
                    Tessellator tessellator = ManualUtils.tes();
                    BufferBuilder buffer = tessellator.func_178180_c();
                    for (int h = 0; h < structureHeight; ++h) {
                        for (int l = 0; l < structureLength; ++l) {
                            for (int w = 0; w < structureWidth; ++w) {
                                BlockPos pos = new BlockPos(l, h, w);
                                if (this.blockAccess.func_175623_d(pos)) continue;
                                GlStateManager.func_179109_b((float)l, (float)h, (float)w);
                                boolean b = this.multiblock.overwriteBlockRender(this.renderInfo.data[h][l][w], idx++);
                                GlStateManager.func_179109_b((float)(-l), (float)(-h), (float)(-w));
                                if (b) continue;
                                IBlockState state = this.blockAccess.func_180495_p(pos);
                                buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                                blockRender.func_175018_a(state, pos, (IBlockAccess)this.blockAccess, buffer);
                                tessellator.func_78381_a();
                            }
                        }
                    }
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179147_l();
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int newStackDepth = GL11.glGetInteger((int)2979); newStackDepth > stackDepth; --newStackDepth) {
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected int getDefaultHeight() {
        return 80;
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        if (this.componentTooltip != null && IIUtils.isPointInRectangle(this.field_146128_h + 116, this.field_146129_i + this.half - 4, this.field_146128_h + 122, this.field_146129_i + this.half + 4, mx, my)) {
            return this.componentTooltip;
        }
        return null;
    }

    public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            if (this.buttonStop.func_146116_c(mc, mouseX, mouseY)) {
                this.showCompleted = !this.showCompleted;
            } else if (this.buttonPause.func_146116_c(mc, mouseX, mouseY)) {
                this.canTick = !this.canTick;
                this.buttonPause.type = this.buttonPause.type == 4 ? 5 : 4;
            } else if (this.buttonUp != null && this.buttonUp.func_146116_c(mc, mouseX, mouseY)) {
                this.renderInfo.setShowLayer(Math.min(this.renderInfo.showLayer + 1, this.renderInfo.structureHeight - 1));
            } else if (this.buttonDown != null && this.buttonDown.func_146116_c(mc, mouseX, mouseY)) {
                this.renderInfo.setShowLayer(Math.max(this.renderInfo.showLayer - 1, -1));
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
        if (this.func_146115_a()) {
            int dx = mx - lastX;
            int dy = my - lastY;
            this.rotY += (float)dx / 104.0f * 80.0f;
            this.rotX += (float)dy / 100.0f * 80.0f;
        }
    }

    static class MultiblockRenderInfo {
        public final MultiblockHandler.IMultiblock multiblock;
        public ItemStack[][][] data;
        public int[] countPerLevel;
        public int structureHeight = 0;
        public int structureLength = 0;
        public int structureWidth = 0;
        public int showLayer = -1;
        private int blockIndex;
        private final int maxBlockIndex;

        public MultiblockRenderInfo(MultiblockHandler.IMultiblock multiblock) {
            this.multiblock = multiblock;
            this.init(multiblock.getStructureManual());
            this.maxBlockIndex = this.blockIndex = this.structureHeight * this.structureLength * this.structureWidth;
        }

        public void init(ItemStack[][][] structure) {
            this.data = structure;
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.countPerLevel = new int[this.structureHeight];
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length > this.structureLength) {
                    this.structureLength = structure[h].length;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length > this.structureWidth) {
                        this.structureWidth = structure[h][l].length;
                    }
                    for (ItemStack ss : structure[h][l]) {
                        if (ss == null || ss.func_190926_b()) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
            }
        }

        public void setShowLayer(int layer) {
            this.showLayer = layer;
            if (layer < 0) {
                this.reset();
            } else {
                this.blockIndex = (layer + 1) * (this.structureLength * this.structureWidth) - 1;
            }
        }

        public void reset() {
            this.blockIndex = this.maxBlockIndex;
        }

        public void step() {
            int start = this.blockIndex;
            do {
                if (++this.blockIndex < this.maxBlockIndex) continue;
                this.blockIndex = 0;
            } while (this.isEmpty(this.blockIndex) && this.blockIndex != start);
        }

        private boolean isEmpty(int index) {
            int y = index / (this.structureLength * this.structureWidth);
            int r = index % (this.structureLength * this.structureWidth);
            int x = r / this.structureWidth;
            int z = r % this.structureWidth;
            ItemStack stack = this.data[y][x][z];
            return stack == null || stack.func_190926_b();
        }

        public int getLimiter() {
            return this.blockIndex;
        }
    }

    @ParametersAreNonnullByDefault
    static class MultiblockBlockAccess
    implements IBlockAccess {
        private final MultiblockRenderInfo data;
        private final IBlockState[][][] structure;

        public MultiblockBlockAccess(MultiblockRenderInfo data) {
            this.data = data;
            int[] index = new int[]{0};
            this.structure = (IBlockState[][][])Arrays.stream(data.data).map(layer -> (IBlockState[][])Arrays.stream(layer).map(row -> Arrays.stream(row).map(itemstack -> {
                int n = index[0];
                index[0] = n + 1;
                return this.convert(n, (ItemStack)itemstack);
            }).collect(Collectors.toList()).toArray(new IBlockState[0])).collect(Collectors.toList()).toArray((T[])new IBlockState[0][])).toArray(x$0 -> new IBlockState[x$0][][]);
        }

        private IBlockState convert(int index, @Nullable ItemStack itemstack) {
            if (itemstack == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            IBlockState state = this.data.multiblock.getBlockstateFromStack(index, itemstack);
            if (state != null) {
                return state;
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        @Nonnull
        public IBlockState func_180495_p(BlockPos pos) {
            int index;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (y >= 0 && y < this.structure.length && x >= 0 && x < this.structure[y].length && z >= 0 && z < this.structure[y][x].length && (index = y * (this.data.structureLength * this.data.structureWidth) + x * this.data.structureWidth + z) <= this.data.getLimiter()) {
                return this.structure[y][x][z];
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
        }

        @Nonnull
        public Biome func_180494_b(BlockPos pos) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                return world.func_180494_b(pos);
            }
            return Biomes.field_150583_P;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        @Nonnull
        public WorldType func_175624_G() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null) {
                return world.func_175624_G();
            }
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return false;
        }
    }
}

