/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMT;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTItem;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTLocator;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTText;
import pl.pabilo8.immersiveintelligence.client.util.amt.AMTWire;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationCompiledMap;
import pl.pabilo8.immersiveintelligence.client.util.amt.IIAnimationUtils;
import pl.pabilo8.immersiveintelligence.common.IIUtils;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualScenario
extends IIManualObject {
    private int animationTime = 0;
    private int maxAnimationTime;
    private float displayScale;
    private float ww;
    private float hh;
    private AMT[] objects;
    private AMT[] overlay;
    private IIAnimationCompiledMap animation;
    private HoverBox[] hovers;
    private String hoveredText = null;

    public IIManualScenario(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        this.objects = (AMT[])this.dataSource.getList((String)"elements", (int)10).field_74747_a.stream().map(this::createAMT).toArray(AMT[]::new);
        this.overlay = (AMT[])this.dataSource.getList((String)"overlay", (int)10).field_74747_a.stream().map(this::createAMT).toArray(AMT[]::new);
        this.hovers = (HoverBox[])this.dataSource.getList((String)"hovers", (int)10).field_74747_a.stream().map(n -> EasyNBT.wrapNBT((NBTTagCompound)n)).map(x$0 -> new HoverBox((EasyNBT)((Object)x$0))).toArray(HoverBox[]::new);
        this.animation = IIAnimationCompiledMap.create(this.joinElements(), new ResourceLocation(this.dataSource.getString("animation")));
        this.maxAnimationTime = this.dataSource.getInt("duration");
        this.ww = (float)this.field_146120_f / 2.0f;
        this.hh = (float)this.field_146121_g / 2.0f;
        this.dataSource.checkSetFloat("scale", f -> {
            this.displayScale = 20.0f * f.floatValue();
        }, 1.0f);
    }

    private AMT[] joinElements() {
        AMT[] amt = new AMT[this.objects.length + this.overlay.length];
        System.arraycopy(this.objects, 0, amt, 0, this.objects.length);
        System.arraycopy(this.overlay, 0, amt, this.objects.length, this.overlay.length);
        return amt;
    }

    @Nonnull
    private AMT createAMT(NBTBase tag) {
        AMT amt;
        EasyNBT nbt = EasyNBT.wrapNBT((NBTTagCompound)tag);
        switch (nbt.getString("type")) {
            case "item": {
                amt = new AMTItem(nbt.getString("name"), Vec3d.field_186680_a);
                ((AMTItem)amt).setStack(nbt.getItemStack("stack"));
                break;
            }
            case "text": {
                amt = new AMTText(nbt.getString("name"), Vec3d.field_186680_a);
                ((AMTText)amt).setText(this.getText(nbt));
                ((AMTText)amt).setFontSize(0.0625f);
                nbt.checkSetString("font_size", ((AMTText)amt)::setText);
                nbt.checkSetInt("color", ((AMTText)amt)::setColor);
                nbt.checkSetFloat("font_size", ((AMTText)amt)::setFontSize);
                break;
            }
            case "wire": {
                amt = new AMTWire(nbt.getString("name"), Vec3d.field_186680_a, nbt.getVec3d("start"), nbt.getVec3d("end"), nbt.getInt("color"), nbt.getFloat("diameter"));
                break;
            }
            default: {
                amt = new AMTLocator(nbt.getString("name"), Vec3d.field_186680_a);
                amt.setChildren(IIAnimationUtils.getAMTFromRes(new ResourceLocation(nbt.getString("model")), null));
            }
        }
        IIAnimationUtils.setModelTranslation(amt, nbt.getVec3d("pos"));
        IIAnimationUtils.setModelRotation(amt, nbt.getVec3d("rot"));
        return amt;
    }

    @Override
    protected int getDefaultHeight() {
        return 64;
    }

    @Override
    protected int getDefaultWidth() {
        return 120;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        if (this.animation != null && this.maxAnimationTime > 0) {
            this.animationTime = (this.animationTime + 1) % this.maxAnimationTime;
            this.animation.apply(((float)this.animationTime + partialTicks) / (float)this.maxAnimationTime);
        }
        GlStateManager.func_187431_e((int)-16777216);
        ClientUtils.drawColouredRect((int)this.field_146128_h, (int)this.field_146129_i, (int)this.field_146120_f, (int)this.field_146121_g, (int)0xF000000);
        GlStateManager.func_187417_n();
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)((float)this.field_146128_h + this.ww), (float)((float)this.field_146129_i + this.hh), (float)100.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)15.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)55.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-this.hh), (float)(-this.hh), (float)0.0f);
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        ClientUtils.drawColouredRect((int)0, (int)0, (int)this.field_146121_g, (int)this.field_146121_g, (int)0x2C000000);
        GlStateManager.func_179109_b((float)this.hh, (float)this.hh, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ClientUtils.bindAtlas();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179152_a((float)this.displayScale, (float)(-this.displayScale), (float)this.displayScale);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        for (AMT mod : this.objects) {
            mod.render(tes, buf);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(this.field_146128_h + 8), (float)(this.field_146129_i + 8), (float)0.0f);
        GlStateManager.func_179152_a((float)-16.0f, (float)16.0f, (float)-16.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        for (AMT mod : this.overlay) {
            mod.render(tes, buf);
        }
        GlStateManager.func_179121_F();
        this.hoveredText = null;
        for (HoverBox hover : this.hovers) {
            if (!IIUtils.isPointInRectangle(hover.x, hover.y, hover.xx, hover.yy, mx, my)) continue;
            this.hoveredText = hover.text;
            break;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        return this.hoveredText == null ? null : Collections.singletonList(this.hoveredText);
    }

    private class HoverBox {
        final int x;
        final int y;
        final int xx;
        final int yy;
        final String text;

        public HoverBox(EasyNBT nbt) {
            this.x = IIManualScenario.this.field_146128_h + nbt.getInt("x");
            this.y = IIManualScenario.this.field_146129_i + nbt.getInt("y");
            this.xx = this.x + nbt.getInt("w");
            this.yy = this.y + nbt.getInt("h");
            this.text = IIManualScenario.this.getText(nbt);
        }
    }
}

