/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.lib.manual.ManualUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualTable
extends IIManualObject {
    String[][] table = null;
    boolean frame;
    int textHeight;
    int[] bars;

    public IIManualTable(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        this.table = (String[][])this.dataSource.getList((String)"table", (int)9).field_74747_a.stream().map(t -> (NBTTagList)t).map(t -> (String[])t.field_74747_a.stream().map(NBTBase::toString).toArray(String[]::new)).toArray(x$0 -> new String[x$0][]);
        this.frame = !this.dataSource.hasKey("frame") || this.dataSource.getBoolean("frame");
        this.textHeight = this.manual.fontRenderer.field_78288_b + 6;
        if (this.table != null) {
            this.calculateBars();
        }
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        if (this.table == null) {
            return;
        }
        this.manual.fontRenderer.func_78264_a(true);
        int col = this.manual.getHighlightColour() | 0xFF000000;
        this.gui.func_73733_a(this.field_146128_h, this.field_146129_i + this.textHeight - 2, this.field_146128_h + 120, this.field_146129_i + this.textHeight - 1, col, col);
        int[] textOff = new int[this.bars != null ? this.bars.length : 0];
        if (this.bars != null) {
            int xx = this.field_146128_h;
            for (int i = 0; i < this.bars.length; ++i) {
                xx += this.bars[i] + 4;
                textOff[i] = xx += 4;
            }
        }
        int yOff = 0;
        for (String[] line : this.table) {
            if (line == null) continue;
            int height = 0;
            for (int j = 0; j < line.length; ++j) {
                if (line[j] == null) continue;
                int xx = textOff.length > 0 && j > 0 ? textOff[j - 1] : this.field_146128_h;
                int w = Math.max(10, 120 - (j > 0 ? textOff[j - 1] - this.field_146128_h : 0));
                ManualUtils.drawSplitString((FontRenderer)this.manual.fontRenderer, (String)line[j], (int)xx, (int)(this.field_146129_i + this.textHeight + yOff), (int)w, (int)this.manual.getTextColour());
                int l = this.manual.fontRenderer.func_78271_c(line[j], w).size();
                if (l <= height) continue;
                height = l;
            }
            if (this.frame) {
                float scale = 0.5f;
                GlStateManager.func_179152_a((float)1.0f, (float)scale, (float)1.0f);
                int barHeight = (int)((float)(this.field_146129_i + this.textHeight + yOff + height * this.manual.fontRenderer.field_78288_b) / scale);
                this.gui.func_73733_a(this.field_146128_h, barHeight, this.field_146128_h + 120, barHeight + 1, this.manual.getTextColour() | 0xFF000000, this.manual.getTextColour() | 0xFF000000);
                GlStateManager.func_179152_a((float)1.0f, (float)(1.0f / scale), (float)1.0f);
            }
            yOff += height * (this.manual.fontRenderer.field_78288_b + 1);
        }
        this.gui.func_73733_a(this.field_146128_h, this.field_146129_i + this.textHeight - 4, this.field_146128_h - 3, this.field_146129_i + this.textHeight + yOff, this.manual.getHighlightColour(), this.manual.getHighlightColour());
        if (this.bars != null) {
            for (int i = 0; i < this.bars.length; ++i) {
                this.gui.func_73733_a(textOff[i] - 4, this.field_146129_i + this.textHeight - 4, textOff[i] - 3, this.field_146129_i + this.textHeight + yOff, col, col);
            }
        }
    }

    @Override
    protected int getDefaultHeight() {
        return 36;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    @Nullable
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        return null;
    }

    private void calculateBars() {
        this.bars = new int[1];
        for (String[] strings : this.table) {
            if (strings.length - 1 > this.bars.length) {
                int[] newBars = new int[strings.length - 1];
                System.arraycopy(this.bars, 0, newBars, 0, this.bars.length);
                this.bars = newBars;
            }
            for (int j = 0; j < strings.length - 1; ++j) {
                int rw = this.manual.fontRenderer.func_78256_a(strings[j]);
                if (rw <= this.bars[j]) continue;
                this.bars[j] = rw;
            }
        }
    }
}

