/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.manual.objects;

import blusunrize.immersiveengineering.client.ClientUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.TextFormatting;
import pl.pabilo8.immersiveintelligence.client.IIClientUtils;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualObject;
import pl.pabilo8.immersiveintelligence.client.manual.IIManualPage;
import pl.pabilo8.immersiveintelligence.common.util.easynbt.EasyNBT;

public class IIManualText
extends IIManualObject {
    private FontRenderer fontRenderer;
    private String text;
    private String tooltip;
    private int color;
    private boolean unicode;
    private boolean textBlock;

    public IIManualText(IIManualObject.ManualObjectInfo info, EasyNBT nbt) {
        super(info, nbt);
    }

    @Override
    public void postInit(IIManualPage page) {
        super.postInit(page);
        this.unicode = false;
        this.dataSource.checkSetBoolean("text_block", b -> {
            this.textBlock = b;
        }, false);
        this.dataSource.checkSetString("tooltip", b -> {
            this.tooltip = b;
        }, "");
        this.dataSource.checkSetInt("color", b -> {
            this.color = b;
        }, -16777216);
        switch (this.dataSource.getString("font")) {
            case "engineer_times": 
            case "times": {
                this.fontRenderer = IIClientUtils.fontEngineerTimes;
                break;
            }
            case "normung": 
            case "bahnhof": {
                this.fontRenderer = IIClientUtils.fontNormung;
                break;
            }
            case "kaiser": 
            case "fraktur": {
                this.fontRenderer = IIClientUtils.fontKaiser;
                break;
            }
            case "tinkerer": {
                this.fontRenderer = IIClientUtils.fontTinkerer;
                break;
            }
            default: {
                this.fontRenderer = this.manual.fontRenderer;
                this.unicode = this.manual.fontRenderer.func_82883_a();
            }
        }
        if (this.dataSource.getBoolean("unicode")) {
            this.unicode = true;
        }
        if (this.dataSource.getBoolean("bold")) {
            this.text = TextFormatting.BOLD + this.text;
        }
        if (this.dataSource.getBoolean("italic")) {
            this.text = TextFormatting.ITALIC + this.text;
        }
        if (this.dataSource.getBoolean("underline")) {
            this.text = TextFormatting.UNDERLINE + this.text;
        }
        if (this.dataSource.getBoolean("strike")) {
            this.text = TextFormatting.STRIKETHROUGH + this.text;
        }
        if (this.dataSource.getBoolean("obfuscated")) {
            this.text = TextFormatting.OBFUSCATED + this.text;
        }
        this.text = this.getText(this.dataSource);
        boolean unicodeFlag = this.fontRenderer.func_82883_a();
        this.fontRenderer.func_78264_a(this.unicode);
        this.field_146121_g = this.fontRenderer.func_78267_b(this.text, this.field_146120_f);
        this.fontRenderer.func_78264_a(unicodeFlag);
    }

    @Override
    public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        super.func_191745_a(mc, mx, my, partialTicks);
        if (this.textBlock) {
            ClientUtils.drawColouredRect((int)(this.field_146128_h - 2), (int)this.field_146129_i, (int)(this.field_146120_f + 2), (int)this.field_146121_g, (int)-1442840576);
        }
        boolean unicodeFlag = this.fontRenderer.func_82883_a();
        this.fontRenderer.func_78264_a(this.unicode);
        this.fontRenderer.func_78279_b(this.text, this.field_146128_h, this.field_146129_i, this.field_146120_f, this.color);
        this.fontRenderer.func_78264_a(unicodeFlag);
    }

    @Override
    protected int getDefaultHeight() {
        return this.field_146121_g;
    }

    @Override
    public void mouseDragged(int x, int y, int clickX, int clickY, int mx, int my, int lastX, int lastY, int button) {
    }

    @Override
    public List<String> getTooltip(Minecraft mc, int mx, int my) {
        if (this.field_146123_n && !this.tooltip.isEmpty()) {
            return Collections.singletonList(this.tooltip);
        }
        return null;
    }
}

