/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.client.model;

import blusunrize.immersiveengineering.client.ImmersiveModelRegistry;
import blusunrize.immersiveengineering.client.models.ModelItemDynamicOverride;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.pabilo8.immersiveintelligence.client.render.IReloadableModelContainer;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIIBase;
import pl.pabilo8.immersiveintelligence.common.util.item.ItemIISubItemsBase;

@SideOnly(value=Side.CLIENT)
public class IIModelRegistry
extends ImmersiveModelRegistry {
    public static IIModelRegistry instance = new IIModelRegistry();
    public final HashMap<ModelResourceLocation, ImmersiveModelRegistry.ItemModelReplacement> itemModelReplacements = new HashMap();
    private final Map<ResourceLocation, IReloadableModelContainer<?>> reloadableModels = new HashMap();
    private final List<IReloadableModelContainer<?>> temporaryReloadableModels = new ArrayList();

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, ImmersiveModelRegistry.ItemModelReplacement> entry : this.itemModelReplacements.entrySet()) {
            IBakedModel object = (IBakedModel)event.getModelRegistry().func_82594_a((Object)entry.getKey());
            if (object == null) continue;
            try {
                event.getModelRegistry().func_82595_a((Object)entry.getKey(), (Object)entry.getValue().createBakedModel(object));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerCustomItemModel(Item item, String modID, ImmersiveModelRegistry.ItemModelReplacement replacement) {
        if (item instanceof ItemIIBase) {
            if (item instanceof ItemIISubItemsBase) {
                ItemIISubItemsBase itemSub = (ItemIISubItemsBase)item;
                for (Enum subItem : itemSub.getSubItems()) {
                    this.itemModelReplacements.put(new ModelResourceLocation(new ResourceLocation(modID, itemSub.itemName + "/" + subItem.func_176610_l()), "inventory"), replacement);
                }
            } else {
                this.itemModelReplacements.put(new ModelResourceLocation(new ResourceLocation(modID, ((ItemIIBase)item).itemName), "inventory"), replacement);
            }
        } else if (item instanceof ItemIEBase) {
            ResourceLocation loc = new ResourceLocation(modID, ((ItemIEBase)item).itemName);
            this.itemModelReplacements.put(new ModelResourceLocation(loc, "inventory"), replacement);
        }
    }

    public void registerCustomItemModel(ItemIEBase item, String modID, int ... IDs) {
        for (int id : IDs) {
            this.itemModelReplacements.put(new ModelResourceLocation(new ResourceLocation(modID, item.itemName + "/" + item.getSubNames()[id]), "inventory"), new ImmersiveModelRegistry.ItemModelReplacement(){

                public IBakedModel createBakedModel(IBakedModel existingModel) {
                    return new ModelItemDynamicOverride(existingModel, null);
                }
            });
        }
    }

    public void registerCustomItemModel(ItemIIBase item) {
        this.registerCustomItemModel(item, "immersiveintelligence", new ImmersiveModelRegistry.ItemModelReplacement(){

            public IBakedModel createBakedModel(IBakedModel existingModel) {
                return new ModelItemDynamicOverride(existingModel, null);
            }
        });
    }

    public void addReloadableModel(IReloadableModelContainer<?> model, ResourceLocation modelName) {
        this.reloadableModels.put(modelName, model);
    }

    public void addTemporaryModel(IReloadableModelContainer<?> temp) {
        this.temporaryReloadableModels.add(temp);
    }

    public void removeReloadableModel(IReloadableModelContainer<?> model) {
        this.reloadableModels.remove(model);
    }

    public void reloadRegisteredModels() {
        this.reloadableModels.values().forEach(IReloadableModelContainer::reloadModels);
    }

    public boolean reloadModel(ResourceLocation modelName) {
        this.reloadableModels.forEach((s, iReloadableModelContainer) -> {
            if (s.equals((Object)modelName)) {
                iReloadableModelContainer.reloadModels();
            }
        });
        return this.reloadableModels.keySet().stream().anyMatch(resourceLocation -> resourceLocation.equals((Object)modelName));
    }

    public Set<ResourceLocation> getReloadableModels() {
        return this.reloadableModels.keySet();
    }

    public void registerSprites(TextureMap map) {
        this.temporaryReloadableModels.forEach(mod -> mod.registerSprites(map));
        this.temporaryReloadableModels.clear();
        this.reloadableModels.values().forEach(mod -> mod.registerSprites(map));
    }
}

